// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class DescribeProjectVersionsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the project that contains the model/adapter you want to describe.
     */
    public val projectArn: kotlin.String? = builder.projectArn
    /**
     * A list of model or project version names that you want to describe. You can add up to 10 model or project version names to the list. If you don't specify a value, all project version descriptions are returned. A version name is part of a project version ARN. For example, `my-model.2020-01-21T09.10.15` is the version name in the following ARN. `arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123`.
     */
    public val versionNames: List<String>? = builder.versionNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeProjectVersionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("projectArn=$projectArn,")
        append("versionNames=$versionNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (projectArn?.hashCode() ?: 0)
        result = 31 * result + (versionNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeProjectVersionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (projectArn != other.projectArn) return false
        if (versionNames != other.versionNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the project that contains the model/adapter you want to describe.
         */
        public var projectArn: kotlin.String? = null
        /**
         * A list of model or project version names that you want to describe. You can add up to 10 model or project version names to the list. If you don't specify a value, all project version descriptions are returned. A version name is part of a project version ARN. For example, `my-model.2020-01-21T09.10.15` is the version name in the following ARN. `arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123`.
         */
        public var versionNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.projectArn = x.projectArn
            this.versionNames = x.versionNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsRequest = DescribeProjectVersionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
