// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description for a dataset. For more information, see DescribeDataset.
 *
 * The status fields `Status`, `StatusMessage`, and `StatusMessageCode` reflect the last operation on the dataset.
 */
public class DatasetDescription private constructor(builder: Builder) {
    /**
     * The Unix timestamp for the time and date that the dataset was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The status message code for the dataset.
     */
    public val datasetStats: aws.sdk.kotlin.services.rekognition.model.DatasetStats? = builder.datasetStats
    /**
     * The Unix timestamp for the date and time that the dataset was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The status of the dataset.
     */
    public val status: aws.sdk.kotlin.services.rekognition.model.DatasetStatus? = builder.status
    /**
     * The status message for the dataset.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed.
     */
    public val statusMessageCode: aws.sdk.kotlin.services.rekognition.model.DatasetStatusMessageCode? = builder.statusMessageCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.DatasetDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetDescription(")
        append("creationTimestamp=$creationTimestamp,")
        append("datasetStats=$datasetStats,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("statusMessageCode=$statusMessageCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (datasetStats?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (statusMessageCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetDescription

        if (creationTimestamp != other.creationTimestamp) return false
        if (datasetStats != other.datasetStats) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (statusMessageCode != other.statusMessageCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.DatasetDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Unix timestamp for the time and date that the dataset was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status message code for the dataset.
         */
        public var datasetStats: aws.sdk.kotlin.services.rekognition.model.DatasetStats? = null
        /**
         * The Unix timestamp for the date and time that the dataset was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the dataset.
         */
        public var status: aws.sdk.kotlin.services.rekognition.model.DatasetStatus? = null
        /**
         * The status message for the dataset.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed.
         */
        public var statusMessageCode: aws.sdk.kotlin.services.rekognition.model.DatasetStatusMessageCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.DatasetDescription) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.datasetStats = x.datasetStats
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.statusMessageCode = x.statusMessageCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.DatasetDescription = DatasetDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.DatasetStats] inside the given [block]
         */
        public fun datasetStats(block: aws.sdk.kotlin.services.rekognition.model.DatasetStats.Builder.() -> kotlin.Unit) {
            this.datasetStats = aws.sdk.kotlin.services.rekognition.model.DatasetStats.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
