// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * A session settings object. It contains settings for the operation to be performed. It accepts arguments for OutputConfig and AuditImagesLimit.
 */
public class CreateFaceLivenessSessionRequestSettings private constructor(builder: Builder) {
    /**
     * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort and is based on the actual duration of the selfie-video.
     */
    public val auditImagesLimit: kotlin.Int? = builder.auditImagesLimit
    /**
     * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that the caller has the `s3:PutObject` permission on the Amazon S3 bucket.
     */
    public val outputConfig: aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig? = builder.outputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFaceLivenessSessionRequestSettings(")
        append("auditImagesLimit=$auditImagesLimit,")
        append("outputConfig=$outputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditImagesLimit ?: 0
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFaceLivenessSessionRequestSettings

        if (auditImagesLimit != other.auditImagesLimit) return false
        if (outputConfig != other.outputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort and is based on the actual duration of the selfie-video.
         */
        public var auditImagesLimit: kotlin.Int? = null
        /**
         * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that the caller has the `s3:PutObject` permission on the Amazon S3 bucket.
         */
        public var outputConfig: aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings) : this() {
            this.auditImagesLimit = x.auditImagesLimit
            this.outputConfig = x.outputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CreateFaceLivenessSessionRequestSettings = CreateFaceLivenessSessionRequestSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.rekognition.model.LivenessOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
