// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class CopyProjectVersionRequest private constructor(builder: Builder) {
    /**
     * The ARN of the project in the trusted AWS account that you want to copy the model version to.
     */
    public val destinationProjectArn: kotlin.String? = builder.destinationProjectArn
    /**
     * The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training results and manifest files written to the output Amazon S3 bucket (`OutputConfig`).
     *
     * If you choose to use your own KMS key, you need the following permissions on the KMS key.
     * + kms:CreateGrant
     * + kms:DescribeKey
     * + kms:GenerateDataKey
     * + kms:Decrypt
     *
     * If you don't specify a value for `KmsKeyId`, images copied into the service are encrypted using a key that AWS owns and manages.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The S3 bucket and folder location where the training output for the source model version is placed.
     */
    public val outputConfig: aws.sdk.kotlin.services.rekognition.model.OutputConfig? = builder.outputConfig
    /**
     * The ARN of the source project in the trusting AWS account.
     */
    public val sourceProjectArn: kotlin.String? = builder.sourceProjectArn
    /**
     * The ARN of the model version in the source project that you want to copy to a destination project.
     */
    public val sourceProjectVersionArn: kotlin.String? = builder.sourceProjectVersionArn
    /**
     * The key-value tags to assign to the model version.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A name for the version of the model that's copied to the destination project.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CopyProjectVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyProjectVersionRequest(")
        append("destinationProjectArn=$destinationProjectArn,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputConfig=$outputConfig,")
        append("sourceProjectArn=$sourceProjectArn,")
        append("sourceProjectVersionArn=$sourceProjectVersionArn,")
        append("tags=$tags,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationProjectArn?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceProjectArn?.hashCode() ?: 0)
        result = 31 * result + (sourceProjectVersionArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyProjectVersionRequest

        if (destinationProjectArn != other.destinationProjectArn) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputConfig != other.outputConfig) return false
        if (sourceProjectArn != other.sourceProjectArn) return false
        if (sourceProjectVersionArn != other.sourceProjectVersionArn) return false
        if (tags != other.tags) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CopyProjectVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the project in the trusted AWS account that you want to copy the model version to.
         */
        public var destinationProjectArn: kotlin.String? = null
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training results and manifest files written to the output Amazon S3 bucket (`OutputConfig`).
         *
         * If you choose to use your own KMS key, you need the following permissions on the KMS key.
         * + kms:CreateGrant
         * + kms:DescribeKey
         * + kms:GenerateDataKey
         * + kms:Decrypt
         *
         * If you don't specify a value for `KmsKeyId`, images copied into the service are encrypted using a key that AWS owns and manages.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The S3 bucket and folder location where the training output for the source model version is placed.
         */
        public var outputConfig: aws.sdk.kotlin.services.rekognition.model.OutputConfig? = null
        /**
         * The ARN of the source project in the trusting AWS account.
         */
        public var sourceProjectArn: kotlin.String? = null
        /**
         * The ARN of the model version in the source project that you want to copy to a destination project.
         */
        public var sourceProjectVersionArn: kotlin.String? = null
        /**
         * The key-value tags to assign to the model version.
         */
        public var tags: Map<String, String>? = null
        /**
         * A name for the version of the model that's copied to the destination project.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CopyProjectVersionRequest) : this() {
            this.destinationProjectArn = x.destinationProjectArn
            this.kmsKeyId = x.kmsKeyId
            this.outputConfig = x.outputConfig
            this.sourceProjectArn = x.sourceProjectArn
            this.sourceProjectVersionArn = x.sourceProjectVersionArn
            this.tags = x.tags
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CopyProjectVersionRequest = CopyProjectVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.rekognition.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.rekognition.model.OutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
