// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Label detection settings to use on a streaming video. Defining the settings is required in the request parameter for CreateStreamProcessor. Including this setting in the `CreateStreamProcessor` request enables you to use the stream processor for label detection. You can then select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For example, if packages and pets are selected, one SNS notification is published the first time a package is detected and one SNS notification is published the first time a pet is detected, as well as an end-of-session summary.
 */
public class ConnectedHomeSettings private constructor(builder: Builder) {
    /**
     * Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
     */
    public val labels: List<String> = requireNotNull(builder.labels) { "A non-null value must be provided for labels" }
    /**
     * The minimum confidence required to label an object in the video.
     */
    public val minConfidence: kotlin.Float? = builder.minConfidence

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectedHomeSettings(")
        append("labels=$labels,")
        append("minConfidence=$minConfidence")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = labels.hashCode()
        result = 31 * result + (minConfidence?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectedHomeSettings

        if (labels != other.labels) return false
        if (minConfidence != other.minConfidence) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
         */
        public var labels: List<String>? = null
        /**
         * The minimum confidence required to label an object in the video.
         */
        public var minConfidence: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings) : this() {
            this.labels = x.labels
            this.minConfidence = x.minConfidence
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.ConnectedHomeSettings = ConnectedHomeSettings(this)

        internal fun correctErrors(): Builder {
            if (labels == null) labels = emptyList()
            return this
        }
    }
}
