// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class CompareFacesResponse private constructor(builder: Builder) {
    /**
     * An array of faces in the target image that match the source image face. Each `CompareFacesMatch` object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity score for the face in the bounding box and the face in the source image.
     */
    public val faceMatches: List<CompareFacesMatch>? = builder.faceMatches
    /**
     * The face in the source image that was used for comparison.
     */
    public val sourceImageFace: aws.sdk.kotlin.services.rekognition.model.ComparedSourceImageFace? = builder.sourceImageFace
    /**
     * The value of `SourceImageOrientationCorrection` is always null.
     *
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.
     */
    public val sourceImageOrientationCorrection: aws.sdk.kotlin.services.rekognition.model.OrientationCorrection? = builder.sourceImageOrientationCorrection
    /**
     * The value of `TargetImageOrientationCorrection` is always null.
     *
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.
     */
    public val targetImageOrientationCorrection: aws.sdk.kotlin.services.rekognition.model.OrientationCorrection? = builder.targetImageOrientationCorrection
    /**
     * An array of faces in the target image that did not match the source image face.
     */
    public val unmatchedFaces: List<ComparedFace>? = builder.unmatchedFaces

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CompareFacesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompareFacesResponse(")
        append("faceMatches=$faceMatches,")
        append("sourceImageFace=$sourceImageFace,")
        append("sourceImageOrientationCorrection=$sourceImageOrientationCorrection,")
        append("targetImageOrientationCorrection=$targetImageOrientationCorrection,")
        append("unmatchedFaces=$unmatchedFaces")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = faceMatches?.hashCode() ?: 0
        result = 31 * result + (sourceImageFace?.hashCode() ?: 0)
        result = 31 * result + (sourceImageOrientationCorrection?.hashCode() ?: 0)
        result = 31 * result + (targetImageOrientationCorrection?.hashCode() ?: 0)
        result = 31 * result + (unmatchedFaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompareFacesResponse

        if (faceMatches != other.faceMatches) return false
        if (sourceImageFace != other.sourceImageFace) return false
        if (sourceImageOrientationCorrection != other.sourceImageOrientationCorrection) return false
        if (targetImageOrientationCorrection != other.targetImageOrientationCorrection) return false
        if (unmatchedFaces != other.unmatchedFaces) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CompareFacesResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of faces in the target image that match the source image face. Each `CompareFacesMatch` object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity score for the face in the bounding box and the face in the source image.
         */
        public var faceMatches: List<CompareFacesMatch>? = null
        /**
         * The face in the source image that was used for comparison.
         */
        public var sourceImageFace: aws.sdk.kotlin.services.rekognition.model.ComparedSourceImageFace? = null
        /**
         * The value of `SourceImageOrientationCorrection` is always null.
         *
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
         *
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.
         */
        public var sourceImageOrientationCorrection: aws.sdk.kotlin.services.rekognition.model.OrientationCorrection? = null
        /**
         * The value of `TargetImageOrientationCorrection` is always null.
         *
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
         *
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.
         */
        public var targetImageOrientationCorrection: aws.sdk.kotlin.services.rekognition.model.OrientationCorrection? = null
        /**
         * An array of faces in the target image that did not match the source image face.
         */
        public var unmatchedFaces: List<ComparedFace>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CompareFacesResponse) : this() {
            this.faceMatches = x.faceMatches
            this.sourceImageFace = x.sourceImageFace
            this.sourceImageOrientationCorrection = x.sourceImageOrientationCorrection
            this.targetImageOrientationCorrection = x.targetImageOrientationCorrection
            this.unmatchedFaces = x.unmatchedFaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CompareFacesResponse = CompareFacesResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.ComparedSourceImageFace] inside the given [block]
         */
        public fun sourceImageFace(block: aws.sdk.kotlin.services.rekognition.model.ComparedSourceImageFace.Builder.() -> kotlin.Unit) {
            this.sourceImageFace = aws.sdk.kotlin.services.rekognition.model.ComparedSourceImageFace.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
