// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



public class CompareFacesRequest private constructor(builder: Builder) {
    /**
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't compared. If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify `NONE`, no filtering is performed. The default value is `NONE`.
     *
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.
     */
    public val qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = builder.qualityFilter
    /**
     * The minimum level of confidence in the face matches that a match must meet to be included in the `FaceMatches` array.
     */
    public val similarityThreshold: kotlin.Float? = builder.similarityThreshold
    /**
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
     *
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
     */
    public val sourceImage: aws.sdk.kotlin.services.rekognition.model.Image? = builder.sourceImage
    /**
     * The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
     *
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
     */
    public val targetImage: aws.sdk.kotlin.services.rekognition.model.Image? = builder.targetImage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.CompareFacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompareFacesRequest(")
        append("qualityFilter=$qualityFilter,")
        append("similarityThreshold=$similarityThreshold,")
        append("sourceImage=$sourceImage,")
        append("targetImage=$targetImage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = qualityFilter?.hashCode() ?: 0
        result = 31 * result + (similarityThreshold?.hashCode() ?: 0)
        result = 31 * result + (sourceImage?.hashCode() ?: 0)
        result = 31 * result + (targetImage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompareFacesRequest

        if (qualityFilter != other.qualityFilter) return false
        if (similarityThreshold != other.similarityThreshold) return false
        if (sourceImage != other.sourceImage) return false
        if (targetImage != other.targetImage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.CompareFacesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't compared. If you specify `AUTO`, Amazon Rekognition chooses the quality bar. If you specify `LOW`, `MEDIUM`, or `HIGH`, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify `NONE`, no filtering is performed. The default value is `NONE`.
         *
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.
         */
        public var qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = null
        /**
         * The minimum level of confidence in the face matches that a match must meet to be included in the `FaceMatches` array.
         */
        public var similarityThreshold: kotlin.Float? = null
        /**
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
         *
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
         */
        public var sourceImage: aws.sdk.kotlin.services.rekognition.model.Image? = null
        /**
         * The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
         *
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the `Bytes` field. For more information, see Images in the Amazon Rekognition developer guide.
         */
        public var targetImage: aws.sdk.kotlin.services.rekognition.model.Image? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.CompareFacesRequest) : this() {
            this.qualityFilter = x.qualityFilter
            this.similarityThreshold = x.similarityThreshold
            this.sourceImage = x.sourceImage
            this.targetImage = x.targetImage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.CompareFacesRequest = CompareFacesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun sourceImage(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.sourceImage = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun targetImage(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.targetImage = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
