// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * Identifies the bounding box around the label, face, text, object of interest, or personal protective equipment. The `left` (x-coordinate) and `top` (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0).
 *
 * The `top` and `left` values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a `left` value of 0.5 (350/700) and a `top` value of 0.25 (50/200).
 *
 * The `width` and `height` values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1.
 *
 *  The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the `left` or `top` values.
 */
public class BoundingBox private constructor(builder: Builder) {
    /**
     * Height of the bounding box as a ratio of the overall image height.
     */
    public val height: kotlin.Float? = builder.height
    /**
     * Left coordinate of the bounding box as a ratio of overall image width.
     */
    public val left: kotlin.Float? = builder.left
    /**
     * Top coordinate of the bounding box as a ratio of overall image height.
     */
    public val top: kotlin.Float? = builder.top
    /**
     * Width of the bounding box as a ratio of the overall image width.
     */
    public val width: kotlin.Float? = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.BoundingBox = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BoundingBox(")
        append("height=$height,")
        append("left=$left,")
        append("top=$top,")
        append("width=$width")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = height?.hashCode() ?: 0
        result = 31 * result + (left?.hashCode() ?: 0)
        result = 31 * result + (top?.hashCode() ?: 0)
        result = 31 * result + (width?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BoundingBox

        if (height != other.height) return false
        if (left != other.left) return false
        if (top != other.top) return false
        if (width != other.width) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.BoundingBox = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Height of the bounding box as a ratio of the overall image height.
         */
        public var height: kotlin.Float? = null
        /**
         * Left coordinate of the bounding box as a ratio of overall image width.
         */
        public var left: kotlin.Float? = null
        /**
         * Top coordinate of the bounding box as a ratio of overall image height.
         */
        public var top: kotlin.Float? = null
        /**
         * Width of the bounding box as a ratio of the overall image width.
         */
        public var width: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.BoundingBox) : this() {
            this.height = x.height
            this.left = x.left
            this.top = x.top
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.BoundingBox = BoundingBox(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
