// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model



/**
 * A filter that allows you to control the black frame detection by specifying the black levels and pixel coverage of black pixels in a frame. As videos can come from multiple sources, formats, and time periods, they may contain different standards and varying noise levels for black frames that need to be accounted for. For more information, see StartSegmentDetection.
 */
public class BlackFrame private constructor(builder: Builder) {
    /**
     * A threshold used to determine the maximum luminance value for a pixel to be considered black. In a full color range video, luminance values range from 0-255. A pixel value of 0 is pure black, and the most strict filter. The maximum black pixel value is computed as follows: max_black_pixel_value = minimum_luminance + MaxPixelThreshold *luminance_range.
     *
     * For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value is 0 + 0.1 * (255-0) = 25.5.
     *
     * The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value of 51 for a full range video. You can lower this threshold to be more strict on black levels.
     */
    public val maxPixelThreshold: kotlin.Float? = builder.maxPixelThreshold
    /**
     * The minimum percentage of pixels in a frame that need to have a luminance below the max_black_pixel_value for a frame to be considered a black frame. Luminance is calculated using the BT.709 matrix.
     *
     * The default value is 99, which means at least 99% of all pixels in the frame are black pixels as per the `MaxPixelThreshold` set. You can reduce this value to allow more noise on the black frame.
     */
    public val minCoveragePercentage: kotlin.Float? = builder.minCoveragePercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.BlackFrame = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlackFrame(")
        append("maxPixelThreshold=$maxPixelThreshold,")
        append("minCoveragePercentage=$minCoveragePercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxPixelThreshold?.hashCode() ?: 0
        result = 31 * result + (minCoveragePercentage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlackFrame

        if (maxPixelThreshold != other.maxPixelThreshold) return false
        if (minCoveragePercentage != other.minCoveragePercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.BlackFrame = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A threshold used to determine the maximum luminance value for a pixel to be considered black. In a full color range video, luminance values range from 0-255. A pixel value of 0 is pure black, and the most strict filter. The maximum black pixel value is computed as follows: max_black_pixel_value = minimum_luminance + MaxPixelThreshold *luminance_range.
         *
         * For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value is 0 + 0.1 * (255-0) = 25.5.
         *
         * The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value of 51 for a full range video. You can lower this threshold to be more strict on black levels.
         */
        public var maxPixelThreshold: kotlin.Float? = null
        /**
         * The minimum percentage of pixels in a frame that need to have a luminance below the max_black_pixel_value for a frame to be considered a black frame. Luminance is calculated using the BT.709 matrix.
         *
         * The default value is 99, which means at least 99% of all pixels in the frame are black pixels as per the `MaxPixelThreshold` set. You can reduce this value to allow more noise on the black frame.
         */
        public var minCoveragePercentage: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.BlackFrame) : this() {
            this.maxPixelThreshold = x.maxPixelThreshold
            this.minCoveragePercentage = x.minCoveragePercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.BlackFrame = BlackFrame(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
