// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.serde

import aws.sdk.kotlin.services.redshiftserverless.model.GetRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RecoveryPoint
import aws.sdk.kotlin.services.redshiftserverless.model.RedshiftServerlessException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRecoveryPointOperationDeserializer: HttpDeserializer.NonStreaming<GetRecoveryPointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRecoveryPointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRecoveryPointError(context, call, payload)
        }
        val builder = GetRecoveryPointResponse.Builder()

        if (payload != null) {
            deserializeGetRecoveryPointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRecoveryPointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftServerlessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecoveryPointOperationBody(builder: GetRecoveryPointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RECOVERYPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("recoveryPoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RECOVERYPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RECOVERYPOINT_DESCRIPTOR.index -> builder.recoveryPoint = deserializeRecoveryPointDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
