// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model



public class UpdateNamespaceRequest private constructor(builder: Builder) {
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret. You can only use this parameter if `manageAdminPassword` is true.
     */
    public val adminPasswordSecretKmsKeyId: kotlin.String? = builder.adminPasswordSecretKmsKeyId
    /**
     * The password of the administrator for the first database created in the namespace. This parameter must be updated together with `adminUsername`.
     *
     * You can't use `adminUserPassword` if `manageAdminPassword` is true.
     */
    public val adminUserPassword: kotlin.String? = builder.adminUserPassword
    /**
     * The username of the administrator for the first database created in the namespace. This parameter must be updated together with `adminUserPassword`.
     */
    public val adminUsername: kotlin.String? = builder.adminUsername
    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter must be updated together with `iamRoles`.
     */
    public val defaultIamRoleArn: kotlin.String? = builder.defaultIamRoleArn
    /**
     * A list of IAM roles to associate with the namespace. This parameter must be updated together with `defaultIamRoleArn`.
     */
    public val iamRoles: List<String>? = builder.iamRoles
    /**
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The types of logs the namespace can export. The export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    public val logExports: List<LogExport>? = builder.logExports
    /**
     * If `true`, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't use `adminUserPassword` if `manageAdminPassword` is true. If `manageAdminPassword` is false or not set, Amazon Redshift uses `adminUserPassword` for the admin user account's password.
     */
    public val manageAdminPassword: kotlin.Boolean? = builder.manageAdminPassword
    /**
     * The name of the namespace to update. You can't update the name of a namespace once it is created.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNamespaceRequest(")
        append("adminPasswordSecretKmsKeyId=$adminPasswordSecretKmsKeyId,")
        append("adminUserPassword=*** Sensitive Data Redacted ***,")
        append("adminUsername=*** Sensitive Data Redacted ***,")
        append("defaultIamRoleArn=$defaultIamRoleArn,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("logExports=$logExports,")
        append("manageAdminPassword=$manageAdminPassword,")
        append("namespaceName=$namespaceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminPasswordSecretKmsKeyId?.hashCode() ?: 0
        result = 31 * result + (adminUserPassword?.hashCode() ?: 0)
        result = 31 * result + (adminUsername?.hashCode() ?: 0)
        result = 31 * result + (defaultIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logExports?.hashCode() ?: 0)
        result = 31 * result + (manageAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateNamespaceRequest

        if (adminPasswordSecretKmsKeyId != other.adminPasswordSecretKmsKeyId) return false
        if (adminUserPassword != other.adminUserPassword) return false
        if (adminUsername != other.adminUsername) return false
        if (defaultIamRoleArn != other.defaultIamRoleArn) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logExports != other.logExports) return false
        if (manageAdminPassword != other.manageAdminPassword) return false
        if (namespaceName != other.namespaceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret. You can only use this parameter if `manageAdminPassword` is true.
         */
        public var adminPasswordSecretKmsKeyId: kotlin.String? = null
        /**
         * The password of the administrator for the first database created in the namespace. This parameter must be updated together with `adminUsername`.
         *
         * You can't use `adminUserPassword` if `manageAdminPassword` is true.
         */
        public var adminUserPassword: kotlin.String? = null
        /**
         * The username of the administrator for the first database created in the namespace. This parameter must be updated together with `adminUserPassword`.
         */
        public var adminUsername: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter must be updated together with `iamRoles`.
         */
        public var defaultIamRoleArn: kotlin.String? = null
        /**
         * A list of IAM roles to associate with the namespace. This parameter must be updated together with `defaultIamRoleArn`.
         */
        public var iamRoles: List<String>? = null
        /**
         * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The types of logs the namespace can export. The export types are `userlog`, `connectionlog`, and `useractivitylog`.
         */
        public var logExports: List<LogExport>? = null
        /**
         * If `true`, Amazon Redshift uses Secrets Manager to manage the namespace's admin credentials. You can't use `adminUserPassword` if `manageAdminPassword` is true. If `manageAdminPassword` is false or not set, Amazon Redshift uses `adminUserPassword` for the admin user account's password.
         */
        public var manageAdminPassword: kotlin.Boolean? = null
        /**
         * The name of the namespace to update. You can't update the name of a namespace once it is created.
         */
        public var namespaceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceRequest) : this() {
            this.adminPasswordSecretKmsKeyId = x.adminPasswordSecretKmsKeyId
            this.adminUserPassword = x.adminUserPassword
            this.adminUsername = x.adminUsername
            this.defaultIamRoleArn = x.defaultIamRoleArn
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.logExports = x.logExports
            this.manageAdminPassword = x.manageAdminPassword
            this.namespaceName = x.namespaceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceRequest = UpdateNamespaceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
