// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The returned scheduled action object.
 */
public class ScheduledActionResponse private constructor(builder: Builder) {
    /**
     * The end time of
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * An array of timestamps of when the next scheduled actions will trigger.
     */
    public val nextInvocations: List<Instant>? = builder.nextInvocations
    /**
     * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see [Using Identity-Based Policies for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.
     *
     * Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
     *
     * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
     */
    public val schedule: aws.sdk.kotlin.services.redshiftserverless.model.Schedule? = builder.schedule
    /**
     * The description of the scheduled action.
     */
    public val scheduledActionDescription: kotlin.String? = builder.scheduledActionDescription
    /**
     * The name of the scheduled action.
     */
    public val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The uuid of the scheduled action.
     */
    public val scheduledActionUuid: kotlin.String? = builder.scheduledActionUuid
    /**
     * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the scheduled action.
     */
    public val state: aws.sdk.kotlin.services.redshiftserverless.model.State? = builder.state
    /**
     * A JSON format string of the Amazon Redshift Serverless API operation with input parameters. The following is an example of a target action.
     *
     * `"{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot", "retentionPeriod": "1"}}"`
     */
    public val targetAction: aws.sdk.kotlin.services.redshiftserverless.model.TargetAction? = builder.targetAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.ScheduledActionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledActionResponse(")
        append("endTime=$endTime,")
        append("namespaceName=$namespaceName,")
        append("nextInvocations=$nextInvocations,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("scheduledActionDescription=$scheduledActionDescription,")
        append("scheduledActionName=$scheduledActionName,")
        append("scheduledActionUuid=$scheduledActionUuid,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("targetAction=$targetAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (nextInvocations?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionDescription?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionUuid?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (targetAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledActionResponse

        if (endTime != other.endTime) return false
        if (namespaceName != other.namespaceName) return false
        if (nextInvocations != other.nextInvocations) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (scheduledActionDescription != other.scheduledActionDescription) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (scheduledActionUuid != other.scheduledActionUuid) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (targetAction != other.targetAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.ScheduledActionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end time of
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * An array of timestamps of when the next scheduled actions will trigger.
         */
        public var nextInvocations: List<Instant>? = null
        /**
         * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see [Using Identity-Based Policies for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide
         */
        public var roleArn: kotlin.String? = null
        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.
         *
         * Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
         *
         * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
         */
        public var schedule: aws.sdk.kotlin.services.redshiftserverless.model.Schedule? = null
        /**
         * The description of the scheduled action.
         */
        public var scheduledActionDescription: kotlin.String? = null
        /**
         * The name of the scheduled action.
         */
        public var scheduledActionName: kotlin.String? = null
        /**
         * The uuid of the scheduled action.
         */
        public var scheduledActionUuid: kotlin.String? = null
        /**
         * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the scheduled action.
         */
        public var state: aws.sdk.kotlin.services.redshiftserverless.model.State? = null
        /**
         * A JSON format string of the Amazon Redshift Serverless API operation with input parameters. The following is an example of a target action.
         *
         * `"{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot", "retentionPeriod": "1"}}"`
         */
        public var targetAction: aws.sdk.kotlin.services.redshiftserverless.model.TargetAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.ScheduledActionResponse) : this() {
            this.endTime = x.endTime
            this.namespaceName = x.namespaceName
            this.nextInvocations = x.nextInvocations
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.scheduledActionDescription = x.scheduledActionDescription
            this.scheduledActionName = x.scheduledActionName
            this.scheduledActionUuid = x.scheduledActionUuid
            this.startTime = x.startTime
            this.state = x.state
            this.targetAction = x.targetAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.ScheduledActionResponse = ScheduledActionResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
