// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an Amazon Redshift Serverless VPC endpoint.
 */
public class EndpointAccess private constructor(builder: Builder) {
    /**
     * The DNS address of the endpoint.
     */
    public val address: kotlin.String? = builder.address
    /**
     * The Amazon Resource Name (ARN) of the VPC endpoint.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The time that the endpoint was created.
     */
    public val endpointCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endpointCreateTime
    /**
     * The name of the VPC endpoint.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The status of the VPC endpoint.
     */
    public val endpointStatus: kotlin.String? = builder.endpointStatus
    /**
     * The port number on which Amazon Redshift Serverless accepts incoming connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The unique identifier of subnets where Amazon Redshift Serverless choose to deploy the VPC endpoint.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The connection endpoint for connecting to Amazon Redshift Serverless.
     */
    public val vpcEndpoint: aws.sdk.kotlin.services.redshiftserverless.model.VpcEndpoint? = builder.vpcEndpoint
    /**
     * The security groups associated with the endpoint.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups
    /**
     * The name of the workgroup associated with the endpoint.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.EndpointAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointAccess(")
        append("address=$address,")
        append("endpointArn=$endpointArn,")
        append("endpointCreateTime=$endpointCreateTime,")
        append("endpointName=$endpointName,")
        append("endpointStatus=$endpointStatus,")
        append("port=$port,")
        append("subnetIds=$subnetIds,")
        append("vpcEndpoint=$vpcEndpoint,")
        append("vpcSecurityGroups=$vpcSecurityGroups,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointCreateTime?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointAccess

        if (address != other.address) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointCreateTime != other.endpointCreateTime) return false
        if (endpointName != other.endpointName) return false
        if (endpointStatus != other.endpointStatus) return false
        if (port != other.port) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcEndpoint != other.vpcEndpoint) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.EndpointAccess = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DNS address of the endpoint.
         */
        public var address: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the VPC endpoint.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The time that the endpoint was created.
         */
        public var endpointCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the VPC endpoint.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The status of the VPC endpoint.
         */
        public var endpointStatus: kotlin.String? = null
        /**
         * The port number on which Amazon Redshift Serverless accepts incoming connections.
         */
        public var port: kotlin.Int? = null
        /**
         * The unique identifier of subnets where Amazon Redshift Serverless choose to deploy the VPC endpoint.
         */
        public var subnetIds: List<String>? = null
        /**
         * The connection endpoint for connecting to Amazon Redshift Serverless.
         */
        public var vpcEndpoint: aws.sdk.kotlin.services.redshiftserverless.model.VpcEndpoint? = null
        /**
         * The security groups associated with the endpoint.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null
        /**
         * The name of the workgroup associated with the endpoint.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.EndpointAccess) : this() {
            this.address = x.address
            this.endpointArn = x.endpointArn
            this.endpointCreateTime = x.endpointCreateTime
            this.endpointName = x.endpointName
            this.endpointStatus = x.endpointStatus
            this.port = x.port
            this.subnetIds = x.subnetIds
            this.vpcEndpoint = x.vpcEndpoint
            this.vpcSecurityGroups = x.vpcSecurityGroups
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.EndpointAccess = EndpointAccess(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshiftserverless.model.VpcEndpoint] inside the given [block]
         */
        public fun vpcEndpoint(block: aws.sdk.kotlin.services.redshiftserverless.model.VpcEndpoint.Builder.() -> kotlin.Unit) {
            this.vpcEndpoint = aws.sdk.kotlin.services.redshiftserverless.model.VpcEndpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
