// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.serde

import aws.sdk.kotlin.services.redshiftserverless.model.Namespace
import aws.sdk.kotlin.services.redshiftserverless.model.RedshiftServerlessException
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RestoreFromSnapshotOperationDeserializer: HttpDeserialize<RestoreFromSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RestoreFromSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreFromSnapshotError(context, call)
        }
        val builder = RestoreFromSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreFromSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRestoreFromSnapshotError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftServerlessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreFromSnapshotOperationBody(builder: RestoreFromSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("namespace"))
    val OWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerAccount"))
    val SNAPSHOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("snapshotName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAMESPACE_DESCRIPTOR)
        field(OWNERACCOUNT_DESCRIPTOR)
        field(SNAPSHOTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAMESPACE_DESCRIPTOR.index -> builder.namespace = deserializeNamespaceDocument(deserializer)
                OWNERACCOUNT_DESCRIPTOR.index -> builder.ownerAccount = deserializeString()
                SNAPSHOTNAME_DESCRIPTOR.index -> builder.snapshotName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
