// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.serde

import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListSnapshotsOperationSerializer: HttpSerialize<ListSnapshotsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListSnapshotsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeListSnapshotsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeListSnapshotsOperationBody(context: ExecutionContext, input: ListSnapshotsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NAMESPACEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceArn"))
    val NAMESPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceName"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerAccount"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NAMESPACEARN_DESCRIPTOR)
        field(NAMESPACENAME_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(OWNERACCOUNT_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.namespaceArn?.let { field(NAMESPACEARN_DESCRIPTOR, it) }
        input.namespaceName?.let { field(NAMESPACENAME_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.ownerAccount?.let { field(OWNERACCOUNT_DESCRIPTOR, it) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
