// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.paginators

import aws.sdk.kotlin.services.redshiftserverless.RedshiftServerlessClient
import aws.sdk.kotlin.services.redshiftserverless.model.Association
import aws.sdk.kotlin.services.redshiftserverless.model.ListCustomDomainAssociationsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListCustomDomainAssociationsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCustomDomainAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomDomainAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomDomainAssociationsResponse]
 */
public fun RedshiftServerlessClient.listCustomDomainAssociationsPaginated(initialRequest: ListCustomDomainAssociationsRequest = ListCustomDomainAssociationsRequest { }): Flow<ListCustomDomainAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomDomainAssociationsPaginated.listCustomDomainAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomDomainAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomDomainAssociationsResponse]
 */
public fun RedshiftServerlessClient.listCustomDomainAssociationsPaginated(block: ListCustomDomainAssociationsRequest.Builder.() -> Unit): Flow<ListCustomDomainAssociationsResponse> =
    listCustomDomainAssociationsPaginated(ListCustomDomainAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomDomainAssociationsPaginated]
 * to access the nested member [Association]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Association]
 */
@JvmName("listCustomDomainAssociationsResponseAssociation")
public fun Flow<ListCustomDomainAssociationsResponse>.associations(): Flow<Association> =
    transform() { response ->
        response.associations?.forEach {
            emit(it)
        }
    }
