// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The collection of computing resources from which an endpoint is created.
 */
public class Workgroup private constructor(builder: Builder) {
    /**
     * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    public val baseCapacity: kotlin.Int? = builder.baseCapacity
    /**
     * An array of parameters to set for advanced control over a database. The options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`, `enable_user_activity_logging`, `query_group`, `search_path`, `require_ssl`, and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [ Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
     */
    public val configParameters: List<ConfigParameter>? = builder.configParameters
    /**
     * The creation date of the workgroup.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A list of VPCs. Each entry is the unique identifier of a virtual private cloud with access to Amazon Redshift Serverless. If all of the VPCs for the grantee are allowed, it shows an asterisk.
     */
    public val crossAccountVpcs: List<String>? = builder.crossAccountVpcs
    /**
     * The custom domain name’s certificate Amazon resource name (ARN).
     */
    public val customDomainCertificateArn: kotlin.String? = builder.customDomainCertificateArn
    /**
     * The expiration time for the certificate.
     */
    public val customDomainCertificateExpiryTime: aws.smithy.kotlin.runtime.time.Instant? = builder.customDomainCertificateExpiryTime
    /**
     * The custom domain name associated with the workgroup.
     */
    public val customDomainName: kotlin.String? = builder.customDomainName
    /**
     * The endpoint that is created from the workgroup.
     */
    public val endpoint: aws.sdk.kotlin.services.redshiftserverless.model.Endpoint? = builder.endpoint
    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     */
    public val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.
     */
    public val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The namespace the workgroup is associated with.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The patch version of your Amazon Redshift Serverless workgroup. For more information about patch versions, see [Cluster versions for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html).
     */
    public val patchVersion: kotlin.String? = builder.patchVersion
    /**
     * The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * A value that specifies whether the workgroup can be accessible from a public network
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * An array of security group IDs to associate with the workgroup.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The status of the workgroup.
     */
    public val status: aws.sdk.kotlin.services.redshiftserverless.model.WorkgroupStatus? = builder.status
    /**
     * An array of subnet IDs the workgroup is associated with.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The Amazon Resource Name (ARN) that links to the workgroup.
     */
    public val workgroupArn: kotlin.String? = builder.workgroupArn
    /**
     * The unique identifier of the workgroup.
     */
    public val workgroupId: kotlin.String? = builder.workgroupId
    /**
     * The name of the workgroup.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName
    /**
     * The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift Serverless versions, see[Cluster versions for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html).
     */
    public val workgroupVersion: kotlin.String? = builder.workgroupVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.Workgroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workgroup(")
        append("baseCapacity=$baseCapacity,")
        append("configParameters=$configParameters,")
        append("creationDate=$creationDate,")
        append("crossAccountVpcs=$crossAccountVpcs,")
        append("customDomainCertificateArn=$customDomainCertificateArn,")
        append("customDomainCertificateExpiryTime=$customDomainCertificateExpiryTime,")
        append("customDomainName=$customDomainName,")
        append("endpoint=$endpoint,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("maxCapacity=$maxCapacity,")
        append("namespaceName=$namespaceName,")
        append("patchVersion=$patchVersion,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroupIds=$securityGroupIds,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("workgroupArn=$workgroupArn,")
        append("workgroupId=$workgroupId,")
        append("workgroupName=$workgroupName,")
        append("workgroupVersion=$workgroupVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCapacity ?: 0
        result = 31 * result + (configParameters?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (crossAccountVpcs?.hashCode() ?: 0)
        result = 31 * result + (customDomainCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (customDomainCertificateExpiryTime?.hashCode() ?: 0)
        result = 31 * result + (customDomainName?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (maxCapacity ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (patchVersion?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (workgroupArn?.hashCode() ?: 0)
        result = 31 * result + (workgroupId?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        result = 31 * result + (workgroupVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workgroup

        if (baseCapacity != other.baseCapacity) return false
        if (configParameters != other.configParameters) return false
        if (creationDate != other.creationDate) return false
        if (crossAccountVpcs != other.crossAccountVpcs) return false
        if (customDomainCertificateArn != other.customDomainCertificateArn) return false
        if (customDomainCertificateExpiryTime != other.customDomainCertificateExpiryTime) return false
        if (customDomainName != other.customDomainName) return false
        if (endpoint != other.endpoint) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (maxCapacity != other.maxCapacity) return false
        if (namespaceName != other.namespaceName) return false
        if (patchVersion != other.patchVersion) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (workgroupArn != other.workgroupArn) return false
        if (workgroupId != other.workgroupId) return false
        if (workgroupName != other.workgroupName) return false
        if (workgroupVersion != other.workgroupVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.Workgroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
         */
        public var baseCapacity: kotlin.Int? = null
        /**
         * An array of parameters to set for advanced control over a database. The options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`, `enable_user_activity_logging`, `query_group`, `search_path`, `require_ssl`, and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [ Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
         */
        public var configParameters: List<ConfigParameter>? = null
        /**
         * The creation date of the workgroup.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of VPCs. Each entry is the unique identifier of a virtual private cloud with access to Amazon Redshift Serverless. If all of the VPCs for the grantee are allowed, it shows an asterisk.
         */
        public var crossAccountVpcs: List<String>? = null
        /**
         * The custom domain name’s certificate Amazon resource name (ARN).
         */
        public var customDomainCertificateArn: kotlin.String? = null
        /**
         * The expiration time for the certificate.
         */
        public var customDomainCertificateExpiryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The custom domain name associated with the workgroup.
         */
        public var customDomainName: kotlin.String? = null
        /**
         * The endpoint that is created from the workgroup.
         */
        public var endpoint: aws.sdk.kotlin.services.redshiftserverless.model.Endpoint? = null
        /**
         * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         */
        public var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.
         */
        public var maxCapacity: kotlin.Int? = null
        /**
         * The namespace the workgroup is associated with.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The patch version of your Amazon Redshift Serverless workgroup. For more information about patch versions, see [Cluster versions for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html).
         */
        public var patchVersion: kotlin.String? = null
        /**
         * The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
         */
        public var port: kotlin.Int? = null
        /**
         * A value that specifies whether the workgroup can be accessible from a public network
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * An array of security group IDs to associate with the workgroup.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The status of the workgroup.
         */
        public var status: aws.sdk.kotlin.services.redshiftserverless.model.WorkgroupStatus? = null
        /**
         * An array of subnet IDs the workgroup is associated with.
         */
        public var subnetIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) that links to the workgroup.
         */
        public var workgroupArn: kotlin.String? = null
        /**
         * The unique identifier of the workgroup.
         */
        public var workgroupId: kotlin.String? = null
        /**
         * The name of the workgroup.
         */
        public var workgroupName: kotlin.String? = null
        /**
         * The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift Serverless versions, see[Cluster versions for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html).
         */
        public var workgroupVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.Workgroup) : this() {
            this.baseCapacity = x.baseCapacity
            this.configParameters = x.configParameters
            this.creationDate = x.creationDate
            this.crossAccountVpcs = x.crossAccountVpcs
            this.customDomainCertificateArn = x.customDomainCertificateArn
            this.customDomainCertificateExpiryTime = x.customDomainCertificateExpiryTime
            this.customDomainName = x.customDomainName
            this.endpoint = x.endpoint
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.maxCapacity = x.maxCapacity
            this.namespaceName = x.namespaceName
            this.patchVersion = x.patchVersion
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroupIds = x.securityGroupIds
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.workgroupArn = x.workgroupArn
            this.workgroupId = x.workgroupId
            this.workgroupName = x.workgroupName
            this.workgroupVersion = x.workgroupVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.Workgroup = Workgroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshiftserverless.model.Endpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.redshiftserverless.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.redshiftserverless.model.Endpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
