// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateScheduledActionRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to enable the scheduled action.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The end time in UTC of the scheduled action to update.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see [Using Identity-Based Policies for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.
     *
     * Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
     *
     * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
     */
    public val schedule: aws.sdk.kotlin.services.redshiftserverless.model.Schedule? = builder.schedule
    /**
     * The descripion of the scheduled action to update to.
     */
    public val scheduledActionDescription: kotlin.String? = builder.scheduledActionDescription
    /**
     * The name of the scheduled action to update to.
     */
    public val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The start time in UTC of the scheduled action to update to.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * A JSON format string of the Amazon Redshift Serverless API operation with input parameters. The following is an example of a target action.
     *
     * `"{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot", "retentionPeriod": "1"}}"`
     */
    public val targetAction: aws.sdk.kotlin.services.redshiftserverless.model.TargetAction? = builder.targetAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.UpdateScheduledActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateScheduledActionRequest(")
        append("enabled=$enabled,")
        append("endTime=$endTime,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("scheduledActionDescription=$scheduledActionDescription,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("targetAction=$targetAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionDescription?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (targetAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateScheduledActionRequest

        if (enabled != other.enabled) return false
        if (endTime != other.endTime) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (scheduledActionDescription != other.scheduledActionDescription) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (targetAction != other.targetAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.UpdateScheduledActionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to enable the scheduled action.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The end time in UTC of the scheduled action to update.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see [Using Identity-Based Policies for Amazon Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide
         */
        public var roleArn: kotlin.String? = null
        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.
         *
         * Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
         *
         * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
         */
        public var schedule: aws.sdk.kotlin.services.redshiftserverless.model.Schedule? = null
        /**
         * The descripion of the scheduled action to update to.
         */
        public var scheduledActionDescription: kotlin.String? = null
        /**
         * The name of the scheduled action to update to.
         */
        public var scheduledActionName: kotlin.String? = null
        /**
         * The start time in UTC of the scheduled action to update to.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A JSON format string of the Amazon Redshift Serverless API operation with input parameters. The following is an example of a target action.
         *
         * `"{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot", "retentionPeriod": "1"}}"`
         */
        public var targetAction: aws.sdk.kotlin.services.redshiftserverless.model.TargetAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.UpdateScheduledActionRequest) : this() {
            this.enabled = x.enabled
            this.endTime = x.endTime
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.scheduledActionDescription = x.scheduledActionDescription
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.targetAction = x.targetAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.UpdateScheduledActionRequest = UpdateScheduledActionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
