// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a table restore request.
 */
public class TableRestoreStatus private constructor(builder: Builder) {
    /**
     * A message that explains the returned status. For example, if the status of the operation is `FAILED`, the message explains why the operation failed.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The namespace of the table being restored from.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The name of the table to create from the restore operation.
     */
    public val newTableName: kotlin.String? = builder.newTableName
    /**
     * The amount of data restored to the new table so far, in megabytes (MB).
     */
    public val progressInMegaBytes: kotlin.Long? = builder.progressInMegaBytes
    /**
     * The ID of the recovery point being restored from.
     */
    public val recoveryPointId: kotlin.String? = builder.recoveryPointId
    /**
     * The time that the table restore request was made, in Universal Coordinated Time (UTC).
     */
    public val requestTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestTime
    /**
     * The name of the snapshot being restored from.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * The name of the source database being restored from.
     */
    public val sourceDatabaseName: kotlin.String? = builder.sourceDatabaseName
    /**
     * The name of the source schema being restored from.
     */
    public val sourceSchemaName: kotlin.String? = builder.sourceSchemaName
    /**
     * The name of the source table being restored from.
     */
    public val sourceTableName: kotlin.String? = builder.sourceTableName
    /**
     * A value that describes the current state of the table restore request. Possible values are `SUCCEEDED`, `FAILED`, `CANCELED`, `PENDING`, and `IN_PROGRESS`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The ID of the RestoreTableFromSnapshot request.
     */
    public val tableRestoreRequestId: kotlin.String? = builder.tableRestoreRequestId
    /**
     * The name of the database to restore to.
     */
    public val targetDatabaseName: kotlin.String? = builder.targetDatabaseName
    /**
     * The name of the schema to restore to.
     */
    public val targetSchemaName: kotlin.String? = builder.targetSchemaName
    /**
     * The total amount of data to restore to the new table, in megabytes (MB).
     */
    public val totalDataInMegaBytes: kotlin.Long? = builder.totalDataInMegaBytes
    /**
     * The name of the workgroup being restored from.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.TableRestoreStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableRestoreStatus(")
        append("message=$message,")
        append("namespaceName=$namespaceName,")
        append("newTableName=$newTableName,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("recoveryPointId=$recoveryPointId,")
        append("requestTime=$requestTime,")
        append("snapshotName=$snapshotName,")
        append("sourceDatabaseName=$sourceDatabaseName,")
        append("sourceSchemaName=$sourceSchemaName,")
        append("sourceTableName=$sourceTableName,")
        append("status=$status,")
        append("tableRestoreRequestId=$tableRestoreRequestId,")
        append("targetDatabaseName=$targetDatabaseName,")
        append("targetSchemaName=$targetSchemaName,")
        append("totalDataInMegaBytes=$totalDataInMegaBytes,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (newTableName?.hashCode() ?: 0)
        result = 31 * result + (progressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointId?.hashCode() ?: 0)
        result = 31 * result + (requestTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (sourceDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (sourceSchemaName?.hashCode() ?: 0)
        result = 31 * result + (sourceTableName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tableRestoreRequestId?.hashCode() ?: 0)
        result = 31 * result + (targetDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (targetSchemaName?.hashCode() ?: 0)
        result = 31 * result + (totalDataInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableRestoreStatus

        if (message != other.message) return false
        if (namespaceName != other.namespaceName) return false
        if (newTableName != other.newTableName) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (recoveryPointId != other.recoveryPointId) return false
        if (requestTime != other.requestTime) return false
        if (snapshotName != other.snapshotName) return false
        if (sourceDatabaseName != other.sourceDatabaseName) return false
        if (sourceSchemaName != other.sourceSchemaName) return false
        if (sourceTableName != other.sourceTableName) return false
        if (status != other.status) return false
        if (tableRestoreRequestId != other.tableRestoreRequestId) return false
        if (targetDatabaseName != other.targetDatabaseName) return false
        if (targetSchemaName != other.targetSchemaName) return false
        if (totalDataInMegaBytes != other.totalDataInMegaBytes) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.TableRestoreStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A message that explains the returned status. For example, if the status of the operation is `FAILED`, the message explains why the operation failed.
         */
        public var message: kotlin.String? = null
        /**
         * The namespace of the table being restored from.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The name of the table to create from the restore operation.
         */
        public var newTableName: kotlin.String? = null
        /**
         * The amount of data restored to the new table so far, in megabytes (MB).
         */
        public var progressInMegaBytes: kotlin.Long? = null
        /**
         * The ID of the recovery point being restored from.
         */
        public var recoveryPointId: kotlin.String? = null
        /**
         * The time that the table restore request was made, in Universal Coordinated Time (UTC).
         */
        public var requestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the snapshot being restored from.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * The name of the source database being restored from.
         */
        public var sourceDatabaseName: kotlin.String? = null
        /**
         * The name of the source schema being restored from.
         */
        public var sourceSchemaName: kotlin.String? = null
        /**
         * The name of the source table being restored from.
         */
        public var sourceTableName: kotlin.String? = null
        /**
         * A value that describes the current state of the table restore request. Possible values are `SUCCEEDED`, `FAILED`, `CANCELED`, `PENDING`, and `IN_PROGRESS`.
         */
        public var status: kotlin.String? = null
        /**
         * The ID of the RestoreTableFromSnapshot request.
         */
        public var tableRestoreRequestId: kotlin.String? = null
        /**
         * The name of the database to restore to.
         */
        public var targetDatabaseName: kotlin.String? = null
        /**
         * The name of the schema to restore to.
         */
        public var targetSchemaName: kotlin.String? = null
        /**
         * The total amount of data to restore to the new table, in megabytes (MB).
         */
        public var totalDataInMegaBytes: kotlin.Long? = null
        /**
         * The name of the workgroup being restored from.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.TableRestoreStatus) : this() {
            this.message = x.message
            this.namespaceName = x.namespaceName
            this.newTableName = x.newTableName
            this.progressInMegaBytes = x.progressInMegaBytes
            this.recoveryPointId = x.recoveryPointId
            this.requestTime = x.requestTime
            this.snapshotName = x.snapshotName
            this.sourceDatabaseName = x.sourceDatabaseName
            this.sourceSchemaName = x.sourceSchemaName
            this.sourceTableName = x.sourceTableName
            this.status = x.status
            this.tableRestoreRequestId = x.tableRestoreRequestId
            this.targetDatabaseName = x.targetDatabaseName
            this.targetSchemaName = x.targetSchemaName
            this.totalDataInMegaBytes = x.totalDataInMegaBytes
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.TableRestoreStatus = TableRestoreStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
