// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model



/**
 * The object that you configure to copy snapshots from one namespace to a namespace in another Amazon Web Services Region.
 */
public class SnapshotCopyConfiguration private constructor(builder: Builder) {
    /**
     * The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.
     */
    public val destinationKmsKeyId: kotlin.String? = builder.destinationKmsKeyId
    /**
     * The destination Amazon Web Services Region to copy snapshots to.
     */
    public val destinationRegion: kotlin.String? = builder.destinationRegion
    /**
     * The name of the namespace to copy snapshots from in the source Amazon Web Services Region.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The ARN of the snapshot copy configuration object.
     */
    public val snapshotCopyConfigurationArn: kotlin.String? = builder.snapshotCopyConfigurationArn
    /**
     * The ID of the snapshot copy configuration object.
     */
    public val snapshotCopyConfigurationId: kotlin.String? = builder.snapshotCopyConfigurationId
    /**
     * The retention period of snapshots that are copied to the destination Amazon Web Services Region.
     */
    public val snapshotRetentionPeriod: kotlin.Int? = builder.snapshotRetentionPeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.SnapshotCopyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotCopyConfiguration(")
        append("destinationKmsKeyId=$destinationKmsKeyId,")
        append("destinationRegion=$destinationRegion,")
        append("namespaceName=$namespaceName,")
        append("snapshotCopyConfigurationArn=$snapshotCopyConfigurationArn,")
        append("snapshotCopyConfigurationId=$snapshotCopyConfigurationId,")
        append("snapshotRetentionPeriod=$snapshotRetentionPeriod")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationKmsKeyId?.hashCode() ?: 0
        result = 31 * result + (destinationRegion?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (snapshotCopyConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotCopyConfigurationId?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionPeriod ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotCopyConfiguration

        if (destinationKmsKeyId != other.destinationKmsKeyId) return false
        if (destinationRegion != other.destinationRegion) return false
        if (namespaceName != other.namespaceName) return false
        if (snapshotCopyConfigurationArn != other.snapshotCopyConfigurationArn) return false
        if (snapshotCopyConfigurationId != other.snapshotCopyConfigurationId) return false
        if (snapshotRetentionPeriod != other.snapshotRetentionPeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.SnapshotCopyConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.
         */
        public var destinationKmsKeyId: kotlin.String? = null
        /**
         * The destination Amazon Web Services Region to copy snapshots to.
         */
        public var destinationRegion: kotlin.String? = null
        /**
         * The name of the namespace to copy snapshots from in the source Amazon Web Services Region.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The ARN of the snapshot copy configuration object.
         */
        public var snapshotCopyConfigurationArn: kotlin.String? = null
        /**
         * The ID of the snapshot copy configuration object.
         */
        public var snapshotCopyConfigurationId: kotlin.String? = null
        /**
         * The retention period of snapshots that are copied to the destination Amazon Web Services Region.
         */
        public var snapshotRetentionPeriod: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.SnapshotCopyConfiguration) : this() {
            this.destinationKmsKeyId = x.destinationKmsKeyId
            this.destinationRegion = x.destinationRegion
            this.namespaceName = x.namespaceName
            this.snapshotCopyConfigurationArn = x.snapshotCopyConfigurationArn
            this.snapshotCopyConfigurationId = x.snapshotCopyConfigurationId
            this.snapshotRetentionPeriod = x.snapshotRetentionPeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.SnapshotCopyConfiguration = SnapshotCopyConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
