// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A collection of database objects and users.
 */
public class Namespace private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
     */
    public val adminPasswordSecretArn: kotlin.String? = builder.adminPasswordSecretArn
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
     */
    public val adminPasswordSecretKmsKeyId: kotlin.String? = builder.adminPasswordSecretKmsKeyId
    /**
     * The username of the administrator for the first database created in the namespace.
     */
    public val adminUsername: kotlin.String? = builder.adminUsername
    /**
     * The date of when the namespace was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The name of the first database created in the namespace.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */
    public val defaultIamRoleArn: kotlin.String? = builder.defaultIamRoleArn
    /**
     * A list of IAM roles to associate with the namespace.
     */
    public val iamRoles: List<String>? = builder.iamRoles
    /**
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The types of logs the namespace can export. Available export types are User log, Connection log, and User activity log.
     */
    public val logExports: List<LogExport>? = builder.logExports
    /**
     * The Amazon Resource Name (ARN) associated with a namespace.
     */
    public val namespaceArn: kotlin.String? = builder.namespaceArn
    /**
     * The unique identifier of a namespace.
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in [Reserved Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The status of the namespace.
     */
    public val status: aws.sdk.kotlin.services.redshiftserverless.model.NamespaceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.Namespace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Namespace(")
        append("adminPasswordSecretArn=$adminPasswordSecretArn,")
        append("adminPasswordSecretKmsKeyId=$adminPasswordSecretKmsKeyId,")
        append("adminUsername=*** Sensitive Data Redacted ***,")
        append("creationDate=$creationDate,")
        append("dbName=$dbName,")
        append("defaultIamRoleArn=$defaultIamRoleArn,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("logExports=$logExports,")
        append("namespaceArn=$namespaceArn,")
        append("namespaceId=$namespaceId,")
        append("namespaceName=$namespaceName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminPasswordSecretArn?.hashCode() ?: 0
        result = 31 * result + (adminPasswordSecretKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (adminUsername?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (defaultIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logExports?.hashCode() ?: 0)
        result = 31 * result + (namespaceArn?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Namespace

        if (adminPasswordSecretArn != other.adminPasswordSecretArn) return false
        if (adminPasswordSecretKmsKeyId != other.adminPasswordSecretKmsKeyId) return false
        if (adminUsername != other.adminUsername) return false
        if (creationDate != other.creationDate) return false
        if (dbName != other.dbName) return false
        if (defaultIamRoleArn != other.defaultIamRoleArn) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logExports != other.logExports) return false
        if (namespaceArn != other.namespaceArn) return false
        if (namespaceId != other.namespaceId) return false
        if (namespaceName != other.namespaceName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.Namespace = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
         */
        public var adminPasswordSecretArn: kotlin.String? = null
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
         */
        public var adminPasswordSecretKmsKeyId: kotlin.String? = null
        /**
         * The username of the administrator for the first database created in the namespace.
         */
        public var adminUsername: kotlin.String? = null
        /**
         * The date of when the namespace was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the first database created in the namespace.
         */
        public var dbName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         */
        public var defaultIamRoleArn: kotlin.String? = null
        /**
         * A list of IAM roles to associate with the namespace.
         */
        public var iamRoles: List<String>? = null
        /**
         * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The types of logs the namespace can export. Available export types are User log, Connection log, and User activity log.
         */
        public var logExports: List<LogExport>? = null
        /**
         * The Amazon Resource Name (ARN) associated with a namespace.
         */
        public var namespaceArn: kotlin.String? = null
        /**
         * The unique identifier of a namespace.
         */
        public var namespaceId: kotlin.String? = null
        /**
         * The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in [Reserved Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The status of the namespace.
         */
        public var status: aws.sdk.kotlin.services.redshiftserverless.model.NamespaceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.Namespace) : this() {
            this.adminPasswordSecretArn = x.adminPasswordSecretArn
            this.adminPasswordSecretKmsKeyId = x.adminPasswordSecretKmsKeyId
            this.adminUsername = x.adminUsername
            this.creationDate = x.creationDate
            this.dbName = x.dbName
            this.defaultIamRoleArn = x.defaultIamRoleArn
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.logExports = x.logExports
            this.namespaceArn = x.namespaceArn
            this.namespaceId = x.namespaceId
            this.namespaceName = x.namespaceName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.Namespace = Namespace(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
