// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.serde

import aws.sdk.kotlin.services.redshiftserverless.model.RedshiftServerlessException
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateCustomDomainAssociationOperationDeserializer: HttpDeserialize<UpdateCustomDomainAssociationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateCustomDomainAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateCustomDomainAssociationError(context, call)
        }
        val builder = UpdateCustomDomainAssociationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateCustomDomainAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateCustomDomainAssociationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftServerlessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateCustomDomainAssociationOperationBody(builder: UpdateCustomDomainAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMDOMAINCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customDomainCertificateArn"))
    val CUSTOMDOMAINCERTIFICATEEXPIRYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("customDomainCertificateExpiryTime"))
    val CUSTOMDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customDomainName"))
    val WORKGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workgroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMDOMAINCERTIFICATEARN_DESCRIPTOR)
        field(CUSTOMDOMAINCERTIFICATEEXPIRYTIME_DESCRIPTOR)
        field(CUSTOMDOMAINNAME_DESCRIPTOR)
        field(WORKGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMDOMAINCERTIFICATEARN_DESCRIPTOR.index -> builder.customDomainCertificateArn = deserializeString()
                CUSTOMDOMAINCERTIFICATEEXPIRYTIME_DESCRIPTOR.index -> builder.customDomainCertificateExpiryTime = deserializeString().let { Instant.fromIso8601(it) }
                CUSTOMDOMAINNAME_DESCRIPTOR.index -> builder.customDomainName = deserializeString()
                WORKGROUPNAME_DESCRIPTOR.index -> builder.workgroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
