// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The schedule of when Amazon Redshift Serverless should run the scheduled action.
 */
public sealed class Schedule {
    /**
     * The timestamp of when Amazon Redshift Serverless should run the scheduled action. Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example, "`at(2016-03-04T17:27:00)`".
     */
    public data class At(val value: aws.smithy.kotlin.runtime.time.Instant) : aws.sdk.kotlin.services.redshiftserverless.model.Schedule() {
    }

    /**
     * The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be separated by at least one hour.
     *
     * Format of cron expressions is "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For example, "`cron(0 10 ? * MON *)`". For more information, see [Cron Expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch Events User Guide*.
     */
    public data class Cron(val value: kotlin.String) : aws.sdk.kotlin.services.redshiftserverless.model.Schedule() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.redshiftserverless.model.Schedule() {
    }

    /**
     * Casts this [Schedule] as a [At] and retrieves its [aws.smithy.kotlin.runtime.time.Instant] value. Throws an exception if the [Schedule] is not a
     * [At].
     */
    public fun asAt(): aws.smithy.kotlin.runtime.time.Instant = (this as Schedule.At).value

    /**
     * Casts this [Schedule] as a [At] and retrieves its [aws.smithy.kotlin.runtime.time.Instant] value. Returns null if the [Schedule] is not a [At].
     */
    public fun asAtOrNull(): aws.smithy.kotlin.runtime.time.Instant? = (this as? Schedule.At)?.value

    /**
     * Casts this [Schedule] as a [Cron] and retrieves its [kotlin.String] value. Throws an exception if the [Schedule] is not a
     * [Cron].
     */
    public fun asCron(): kotlin.String = (this as Schedule.Cron).value

    /**
     * Casts this [Schedule] as a [Cron] and retrieves its [kotlin.String] value. Returns null if the [Schedule] is not a [Cron].
     */
    public fun asCronOrNull(): kotlin.String? = (this as? Schedule.Cron)?.value
}
