// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model



public class RestoreFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
     */
    public val adminPasswordSecretKmsKeyId: kotlin.String? = builder.adminPasswordSecretKmsKeyId
    /**
     * If `true`, Amazon Redshift uses Secrets Manager to manage the restored snapshot's admin credentials. If `MmanageAdminPassword` is false or not set, Amazon Redshift uses the admin credentials that the namespace or cluster had at the time the snapshot was taken.
     */
    public val manageAdminPassword: kotlin.Boolean? = builder.manageAdminPassword
    /**
     * The name of the namespace to restore the snapshot to.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The Amazon Web Services account that owns the snapshot.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon Redshift Serverless to a provisioned cluster. Must not be specified at the same time as `snapshotName`.
     *
     * The format of the ARN is arn:aws:redshift:<region>:<account_id>:snapshot:<cluster_identifier>/<snapshot_identifier>.
     */
    public val snapshotArn: kotlin.String? = builder.snapshotArn
    /**
     * The name of the snapshot to restore from. Must not be specified at the same time as `snapshotArn`.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * The name of the workgroup used to restore the snapshot.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreFromSnapshotRequest(")
        append("adminPasswordSecretKmsKeyId=$adminPasswordSecretKmsKeyId,")
        append("manageAdminPassword=$manageAdminPassword,")
        append("namespaceName=$namespaceName,")
        append("ownerAccount=$ownerAccount,")
        append("snapshotArn=$snapshotArn,")
        append("snapshotName=$snapshotName,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminPasswordSecretKmsKeyId?.hashCode() ?: 0
        result = 31 * result + (manageAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (snapshotArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreFromSnapshotRequest

        if (adminPasswordSecretKmsKeyId != other.adminPasswordSecretKmsKeyId) return false
        if (manageAdminPassword != other.manageAdminPassword) return false
        if (namespaceName != other.namespaceName) return false
        if (ownerAccount != other.ownerAccount) return false
        if (snapshotArn != other.snapshotArn) return false
        if (snapshotName != other.snapshotName) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials secret.
         */
        public var adminPasswordSecretKmsKeyId: kotlin.String? = null
        /**
         * If `true`, Amazon Redshift uses Secrets Manager to manage the restored snapshot's admin credentials. If `MmanageAdminPassword` is false or not set, Amazon Redshift uses the admin credentials that the namespace or cluster had at the time the snapshot was taken.
         */
        public var manageAdminPassword: kotlin.Boolean? = null
        /**
         * The name of the namespace to restore the snapshot to.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The Amazon Web Services account that owns the snapshot.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon Redshift Serverless to a provisioned cluster. Must not be specified at the same time as `snapshotName`.
         *
         * The format of the ARN is arn:aws:redshift:<region>:<account_id>:snapshot:<cluster_identifier>/<snapshot_identifier>.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The name of the snapshot to restore from. Must not be specified at the same time as `snapshotArn`.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * The name of the workgroup used to restore the snapshot.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotRequest) : this() {
            this.adminPasswordSecretKmsKeyId = x.adminPasswordSecretKmsKeyId
            this.manageAdminPassword = x.manageAdminPassword
            this.namespaceName = x.namespaceName
            this.ownerAccount = x.ownerAccount
            this.snapshotArn = x.snapshotArn
            this.snapshotName = x.snapshotName
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotRequest = RestoreFromSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
