// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model



public class GetCredentialsRequest private constructor(builder: Builder) {
    /**
     * The custom domain name associated with the workgroup. The custom domain name or the workgroup name must be included in the request.
     */
    public val customDomainName: kotlin.String? = builder.customDomainName
    /**
     * The name of the database to get temporary authorization to log on to.
     *
     * Constraints:
     * + Must be 1 to 64 alphanumeric characters or hyphens.
     * + Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
     * + The first character must be a letter.
     * + Must not contain a colon ( : ) or slash ( / ).
     * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words ](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
     */
    public val durationSeconds: kotlin.Int? = builder.durationSeconds
    /**
     * The name of the workgroup associated with the database.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCredentialsRequest(")
        append("customDomainName=$customDomainName,")
        append("dbName=$dbName,")
        append("durationSeconds=$durationSeconds,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDomainName?.hashCode() ?: 0
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (durationSeconds ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCredentialsRequest

        if (customDomainName != other.customDomainName) return false
        if (dbName != other.dbName) return false
        if (durationSeconds != other.durationSeconds) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The custom domain name associated with the workgroup. The custom domain name or the workgroup name must be included in the request.
         */
        public var customDomainName: kotlin.String? = null
        /**
         * The name of the database to get temporary authorization to log on to.
         *
         * Constraints:
         * + Must be 1 to 64 alphanumeric characters or hyphens.
         * + Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
         * + The first character must be a letter.
         * + Must not contain a colon ( : ) or slash ( / ).
         * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words ](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide
         */
        public var dbName: kotlin.String? = null
        /**
         * The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
         */
        public var durationSeconds: kotlin.Int? = null
        /**
         * The name of the workgroup associated with the database.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsRequest) : this() {
            this.customDomainName = x.customDomainName
            this.dbName = x.dbName
            this.durationSeconds = x.durationSeconds
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsRequest = GetCredentialsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
