// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model



/**
 * The parameters that you can use to configure a [scheduled action](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html) to create a snapshot. For more information about creating a scheduled action, see [CreateScheduledAction](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html).
 */
public class CreateSnapshotScheduleActionParameters private constructor(builder: Builder) {
    /**
     * The name of the namespace for which you want to configure a scheduled action to create a snapshot.
     */
    public val namespaceName: kotlin.String = requireNotNull(builder.namespaceName) { "A non-null value must be provided for namespaceName" }
    /**
     * The retention period of the snapshot created by the scheduled action.
     */
    public val retentionPeriod: kotlin.Int? = builder.retentionPeriod
    /**
     * A string prefix that is attached to the name of the snapshot created by the scheduled action. The final name of the snapshot is the string prefix appended by the date and time of when the snapshot was created.
     */
    public val snapshotNamePrefix: kotlin.String = requireNotNull(builder.snapshotNamePrefix) { "A non-null value must be provided for snapshotNamePrefix" }
    /**
     * An array of [Tag objects](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html) to associate with the snapshot.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotScheduleActionParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotScheduleActionParameters(")
        append("namespaceName=$namespaceName,")
        append("retentionPeriod=$retentionPeriod,")
        append("snapshotNamePrefix=$snapshotNamePrefix,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespaceName.hashCode()
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (snapshotNamePrefix.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSnapshotScheduleActionParameters

        if (namespaceName != other.namespaceName) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snapshotNamePrefix != other.snapshotNamePrefix) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotScheduleActionParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the namespace for which you want to configure a scheduled action to create a snapshot.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The retention period of the snapshot created by the scheduled action.
         */
        public var retentionPeriod: kotlin.Int? = null
        /**
         * A string prefix that is attached to the name of the snapshot created by the scheduled action. The final name of the snapshot is the string prefix appended by the date and time of when the snapshot was created.
         */
        public var snapshotNamePrefix: kotlin.String? = null
        /**
         * An array of [Tag objects](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html) to associate with the snapshot.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotScheduleActionParameters) : this() {
            this.namespaceName = x.namespaceName
            this.retentionPeriod = x.retentionPeriod
            this.snapshotNamePrefix = x.snapshotNamePrefix
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotScheduleActionParameters = CreateSnapshotScheduleActionParameters(this)

        internal fun correctErrors(): Builder {
            if (namespaceName == null) namespaceName = ""
            if (snapshotNamePrefix == null) snapshotNamePrefix = ""
            return this
        }
    }
}
