// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.redshiftserverless.auth.DefaultRedshiftServerlessAuthSchemeProvider
import aws.sdk.kotlin.services.redshiftserverless.auth.RedshiftServerlessAuthSchemeProvider
import aws.sdk.kotlin.services.redshiftserverless.endpoints.DefaultRedshiftServerlessEndpointProvider
import aws.sdk.kotlin.services.redshiftserverless.endpoints.RedshiftServerlessEndpointParameters
import aws.sdk.kotlin.services.redshiftserverless.endpoints.RedshiftServerlessEndpointProvider
import aws.sdk.kotlin.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateScheduledActionRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateScheduledActionResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotCopyConfigurationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotCopyConfigurationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteScheduledActionRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteScheduledActionResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteWorkgroupResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetRecoveryPointRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetScheduledActionRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetScheduledActionResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetTableRestoreStatusRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetTableRestoreStatusResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetWorkgroupResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListCustomDomainAssociationsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListCustomDomainAssociationsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListNamespacesRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListNamespacesResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListRecoveryPointsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListRecoveryPointsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListScheduledActionsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListScheduledActionsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListTableRestoreStatusRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListTableRestoreStatusResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListUsageLimitsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListUsageLimitsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListWorkgroupsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListWorkgroupsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.redshiftserverless.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromRecoveryPointRequest
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreTableFromRecoveryPointRequest
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreTableFromRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreTableFromSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreTableFromSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.TagResourceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.TagResourceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UntagResourceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UntagResourceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateScheduledActionRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateScheduledActionResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateWorkgroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Redshift Serverless"
public const val SdkVersion: String = "1.0.17"

/**
 * This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift Serverless.
 *
 * Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift Serverless lets you focus on using your data to acquire new insights for your business and customers.
 *
 *  To learn more about Amazon Redshift Serverless, see [What is Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html).
 */
public interface RedshiftServerlessClient : SdkClient {
    /**
     * RedshiftServerlessClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, RedshiftServerlessClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "RedshiftServerless",
                "REDSHIFT_SERVERLESS",
                "redshift_serverless",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, RedshiftServerlessClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): RedshiftServerlessClient = DefaultRedshiftServerlessClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: RedshiftServerlessEndpointProvider = builder.endpointProvider ?: DefaultRedshiftServerlessEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: RedshiftServerlessAuthSchemeProvider = builder.authSchemeProvider ?: DefaultRedshiftServerlessAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Redshift Serverless"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: RedshiftServerlessEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: RedshiftServerlessAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    public suspend fun convertRecoveryPointToSnapshot(input: ConvertRecoveryPointToSnapshotRequest): ConvertRecoveryPointToSnapshotResponse

    /**
     * Creates a custom domain association for Amazon Redshift Serverless.
     */
    public suspend fun createCustomDomainAssociation(input: CreateCustomDomainAssociationRequest): CreateCustomDomainAssociationResponse

    /**
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     */
    public suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse

    /**
     * Creates a namespace in Amazon Redshift Serverless.
     */
    public suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse

    /**
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `CreateSnapshot` API operation.
     */
    public suspend fun createScheduledAction(input: CreateScheduledActionRequest): CreateScheduledActionResponse

    /**
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.
     */
    public suspend fun createSnapshotCopyConfiguration(input: CreateSnapshotCopyConfigurationRequest): CreateSnapshotCopyConfigurationResponse

    /**
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
     */
    public suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse

    /**
     * Creates an workgroup in Amazon Redshift Serverless.
     */
    public suspend fun createWorkgroup(input: CreateWorkgroupRequest): CreateWorkgroupResponse

    /**
     * Deletes a custom domain association for Amazon Redshift Serverless.
     */
    public suspend fun deleteCustomDomainAssociation(input: DeleteCustomDomainAssociationRequest): DeleteCustomDomainAssociationResponse

    /**
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     */
    public suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse

    /**
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
     */
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes the specified resource policy.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a scheduled action.
     */
    public suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse

    /**
     * Deletes a snapshot from Amazon Redshift Serverless.
     */
    public suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes a snapshot copy configuration
     */
    public suspend fun deleteSnapshotCopyConfiguration(input: DeleteSnapshotCopyConfigurationRequest): DeleteSnapshotCopyConfigurationResponse

    /**
     * Deletes a usage limit from Amazon Redshift Serverless.
     */
    public suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse

    /**
     * Deletes a workgroup.
     */
    public suspend fun deleteWorkgroup(input: DeleteWorkgroupRequest): DeleteWorkgroupResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
     *
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
     *
     * The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
     *
     * If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
     */
    public suspend fun getCredentials(input: GetCredentialsRequest = GetCredentialsRequest { }): GetCredentialsResponse

    /**
     * Gets information about a specific custom domain association.
     */
    public suspend fun getCustomDomainAssociation(input: GetCustomDomainAssociationRequest): GetCustomDomainAssociationResponse

    /**
     * Returns information, such as the name, about a VPC endpoint.
     */
    public suspend fun getEndpointAccess(input: GetEndpointAccessRequest): GetEndpointAccessResponse

    /**
     * Returns information about a namespace in Amazon Redshift Serverless.
     */
    public suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse

    /**
     * Returns information about a recovery point.
     */
    public suspend fun getRecoveryPoint(input: GetRecoveryPointRequest): GetRecoveryPointResponse

    /**
     * Returns a resource policy.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Returns information about a scheduled action.
     */
    public suspend fun getScheduledAction(input: GetScheduledActionRequest): GetScheduledActionResponse

    /**
     * Returns information about a specific snapshot.
     */
    public suspend fun getSnapshot(input: GetSnapshotRequest = GetSnapshotRequest { }): GetSnapshotResponse

    /**
     * Returns information about a `TableRestoreStatus` object.
     */
    public suspend fun getTableRestoreStatus(input: GetTableRestoreStatusRequest): GetTableRestoreStatusResponse

    /**
     * Returns information about a usage limit.
     */
    public suspend fun getUsageLimit(input: GetUsageLimitRequest): GetUsageLimitResponse

    /**
     * Returns information about a specific workgroup.
     */
    public suspend fun getWorkgroup(input: GetWorkgroupRequest): GetWorkgroupResponse

    /**
     * Lists custom domain associations for Amazon Redshift Serverless.
     */
    public suspend fun listCustomDomainAssociations(input: ListCustomDomainAssociationsRequest = ListCustomDomainAssociationsRequest { }): ListCustomDomainAssociationsResponse

    /**
     * Returns an array of `EndpointAccess` objects and relevant information.
     */
    public suspend fun listEndpointAccess(input: ListEndpointAccessRequest = ListEndpointAccessRequest { }): ListEndpointAccessResponse

    /**
     * Returns information about a list of specified namespaces.
     */
    public suspend fun listNamespaces(input: ListNamespacesRequest = ListNamespacesRequest { }): ListNamespacesResponse

    /**
     * Returns an array of recovery points.
     */
    public suspend fun listRecoveryPoints(input: ListRecoveryPointsRequest = ListRecoveryPointsRequest { }): ListRecoveryPointsResponse

    /**
     * Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.
     */
    public suspend fun listScheduledActions(input: ListScheduledActionsRequest = ListScheduledActionsRequest { }): ListScheduledActionsResponse

    /**
     * Returns a list of snapshot copy configurations.
     */
    public suspend fun listSnapshotCopyConfigurations(input: ListSnapshotCopyConfigurationsRequest = ListSnapshotCopyConfigurationsRequest { }): ListSnapshotCopyConfigurationsResponse

    /**
     * Returns a list of snapshots.
     */
    public suspend fun listSnapshots(input: ListSnapshotsRequest = ListSnapshotsRequest { }): ListSnapshotsResponse

    /**
     * Returns information about an array of `TableRestoreStatus` objects.
     */
    public suspend fun listTableRestoreStatus(input: ListTableRestoreStatusRequest = ListTableRestoreStatusRequest { }): ListTableRestoreStatusResponse

    /**
     * Lists the tags assigned to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all usage limits within Amazon Redshift Serverless.
     */
    public suspend fun listUsageLimits(input: ListUsageLimitsRequest = ListUsageLimitsRequest { }): ListUsageLimitsResponse

    /**
     * Returns information about a list of specified workgroups.
     */
    public suspend fun listWorkgroups(input: ListWorkgroupsRequest = ListWorkgroupsRequest { }): ListWorkgroupsResponse

    /**
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Restore the data from a recovery point.
     */
    public suspend fun restoreFromRecoveryPoint(input: RestoreFromRecoveryPointRequest): RestoreFromRecoveryPointResponse

    /**
     * Restores a namespace from a snapshot.
     */
    public suspend fun restoreFromSnapshot(input: RestoreFromSnapshotRequest): RestoreFromSnapshotResponse

    /**
     * Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with interleaved sort keys.
     */
    public suspend fun restoreTableFromRecoveryPoint(input: RestoreTableFromRecoveryPointRequest): RestoreTableFromRecoveryPointResponse

    /**
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with [interleaved sort keys](https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved).
     */
    public suspend fun restoreTableFromSnapshot(input: RestoreTableFromSnapshotRequest): RestoreTableFromSnapshotResponse

    /**
     * Assigns one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or set of tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
     */
    public suspend fun updateCustomDomainAssociation(input: UpdateCustomDomainAssociationRequest): UpdateCustomDomainAssociationResponse

    /**
     * Updates an Amazon Redshift Serverless managed endpoint.
     */
    public suspend fun updateEndpointAccess(input: UpdateEndpointAccessRequest): UpdateEndpointAccessResponse

    /**
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one request. For example, you must specify both `adminUsername` and `adminUserPassword` to update either field, but you can't update both `kmsKeyId` and `logExports` in a single request.
     */
    public suspend fun updateNamespace(input: UpdateNamespaceRequest): UpdateNamespaceResponse

    /**
     * Updates a scheduled action.
     */
    public suspend fun updateScheduledAction(input: UpdateScheduledActionRequest): UpdateScheduledActionResponse

    /**
     * Updates a snapshot.
     */
    public suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse

    /**
     * Updates a snapshot copy configuration.
     */
    public suspend fun updateSnapshotCopyConfiguration(input: UpdateSnapshotCopyConfigurationRequest): UpdateSnapshotCopyConfigurationResponse

    /**
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     */
    public suspend fun updateUsageLimit(input: UpdateUsageLimitRequest): UpdateUsageLimitResponse

    /**
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one request. For example, you can update `baseCapacity` or `port` in a single request, but you can't update both in the same request.
     */
    public suspend fun updateWorkgroup(input: UpdateWorkgroupRequest): UpdateWorkgroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun RedshiftServerlessClient.withConfig(block: RedshiftServerlessClient.Config.Builder.() -> Unit): RedshiftServerlessClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRedshiftServerlessClient(newConfig)
}

/**
 * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
 */
public suspend inline fun RedshiftServerlessClient.convertRecoveryPointToSnapshot(crossinline block: ConvertRecoveryPointToSnapshotRequest.Builder.() -> Unit): ConvertRecoveryPointToSnapshotResponse = convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a custom domain association for Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.createCustomDomainAssociation(crossinline block: CreateCustomDomainAssociationRequest.Builder.() -> Unit): CreateCustomDomainAssociationResponse = createCustomDomainAssociation(CreateCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Redshift Serverless managed VPC endpoint.
 */
public suspend inline fun RedshiftServerlessClient.createEndpointAccess(crossinline block: CreateEndpointAccessRequest.Builder.() -> Unit): CreateEndpointAccessResponse = createEndpointAccess(CreateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Creates a namespace in Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.createNamespace(crossinline block: CreateNamespaceRequest.Builder.() -> Unit): CreateNamespaceResponse = createNamespace(CreateNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `CreateSnapshot` API operation.
 */
public suspend inline fun RedshiftServerlessClient.createScheduledAction(crossinline block: CreateScheduledActionRequest.Builder.() -> Unit): CreateScheduledActionResponse = createScheduledAction(CreateScheduledActionRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
 */
public suspend inline fun RedshiftServerlessClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.
 */
public suspend inline fun RedshiftServerlessClient.createSnapshotCopyConfiguration(crossinline block: CreateSnapshotCopyConfigurationRequest.Builder.() -> Unit): CreateSnapshotCopyConfigurationResponse = createSnapshotCopyConfiguration(CreateSnapshotCopyConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
 */
public suspend inline fun RedshiftServerlessClient.createUsageLimit(crossinline block: CreateUsageLimitRequest.Builder.() -> Unit): CreateUsageLimitResponse = createUsageLimit(CreateUsageLimitRequest.Builder().apply(block).build())

/**
 * Creates an workgroup in Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.createWorkgroup(crossinline block: CreateWorkgroupRequest.Builder.() -> Unit): CreateWorkgroupResponse = createWorkgroup(CreateWorkgroupRequest.Builder().apply(block).build())

/**
 * Deletes a custom domain association for Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.deleteCustomDomainAssociation(crossinline block: DeleteCustomDomainAssociationRequest.Builder.() -> Unit): DeleteCustomDomainAssociationResponse = deleteCustomDomainAssociation(DeleteCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Redshift Serverless managed VPC endpoint.
 */
public suspend inline fun RedshiftServerlessClient.deleteEndpointAccess(crossinline block: DeleteEndpointAccessRequest.Builder.() -> Unit): DeleteEndpointAccessResponse = deleteEndpointAccess(DeleteEndpointAccessRequest.Builder().apply(block).build())

/**
 * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
 */
public suspend inline fun RedshiftServerlessClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource policy.
 */
public suspend inline fun RedshiftServerlessClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a scheduled action.
 */
public suspend inline fun RedshiftServerlessClient.deleteScheduledAction(crossinline block: DeleteScheduledActionRequest.Builder.() -> Unit): DeleteScheduledActionResponse = deleteScheduledAction(DeleteScheduledActionRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot from Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit): DeleteSnapshotResponse = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot copy configuration
 */
public suspend inline fun RedshiftServerlessClient.deleteSnapshotCopyConfiguration(crossinline block: DeleteSnapshotCopyConfigurationRequest.Builder.() -> Unit): DeleteSnapshotCopyConfigurationResponse = deleteSnapshotCopyConfiguration(DeleteSnapshotCopyConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a usage limit from Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.deleteUsageLimit(crossinline block: DeleteUsageLimitRequest.Builder.() -> Unit): DeleteUsageLimitResponse = deleteUsageLimit(DeleteUsageLimitRequest.Builder().apply(block).build())

/**
 * Deletes a workgroup.
 */
public suspend inline fun RedshiftServerlessClient.deleteWorkgroup(crossinline block: DeleteWorkgroupRequest.Builder.() -> Unit): DeleteWorkgroupResponse = deleteWorkgroup(DeleteWorkgroupRequest.Builder().apply(block).build())

/**
 * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
 *
 * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
 *
 * The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
 *
 * If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
 */
public suspend inline fun RedshiftServerlessClient.getCredentials(crossinline block: GetCredentialsRequest.Builder.() -> Unit): GetCredentialsResponse = getCredentials(GetCredentialsRequest.Builder().apply(block).build())

/**
 * Gets information about a specific custom domain association.
 */
public suspend inline fun RedshiftServerlessClient.getCustomDomainAssociation(crossinline block: GetCustomDomainAssociationRequest.Builder.() -> Unit): GetCustomDomainAssociationResponse = getCustomDomainAssociation(GetCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Returns information, such as the name, about a VPC endpoint.
 */
public suspend inline fun RedshiftServerlessClient.getEndpointAccess(crossinline block: GetEndpointAccessRequest.Builder.() -> Unit): GetEndpointAccessResponse = getEndpointAccess(GetEndpointAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a namespace in Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.getNamespace(crossinline block: GetNamespaceRequest.Builder.() -> Unit): GetNamespaceResponse = getNamespace(GetNamespaceRequest.Builder().apply(block).build())

/**
 * Returns information about a recovery point.
 */
public suspend inline fun RedshiftServerlessClient.getRecoveryPoint(crossinline block: GetRecoveryPointRequest.Builder.() -> Unit): GetRecoveryPointResponse = getRecoveryPoint(GetRecoveryPointRequest.Builder().apply(block).build())

/**
 * Returns a resource policy.
 */
public suspend inline fun RedshiftServerlessClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns information about a scheduled action.
 */
public suspend inline fun RedshiftServerlessClient.getScheduledAction(crossinline block: GetScheduledActionRequest.Builder.() -> Unit): GetScheduledActionResponse = getScheduledAction(GetScheduledActionRequest.Builder().apply(block).build())

/**
 * Returns information about a specific snapshot.
 */
public suspend inline fun RedshiftServerlessClient.getSnapshot(crossinline block: GetSnapshotRequest.Builder.() -> Unit): GetSnapshotResponse = getSnapshot(GetSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about a `TableRestoreStatus` object.
 */
public suspend inline fun RedshiftServerlessClient.getTableRestoreStatus(crossinline block: GetTableRestoreStatusRequest.Builder.() -> Unit): GetTableRestoreStatusResponse = getTableRestoreStatus(GetTableRestoreStatusRequest.Builder().apply(block).build())

/**
 * Returns information about a usage limit.
 */
public suspend inline fun RedshiftServerlessClient.getUsageLimit(crossinline block: GetUsageLimitRequest.Builder.() -> Unit): GetUsageLimitResponse = getUsageLimit(GetUsageLimitRequest.Builder().apply(block).build())

/**
 * Returns information about a specific workgroup.
 */
public suspend inline fun RedshiftServerlessClient.getWorkgroup(crossinline block: GetWorkgroupRequest.Builder.() -> Unit): GetWorkgroupResponse = getWorkgroup(GetWorkgroupRequest.Builder().apply(block).build())

/**
 * Lists custom domain associations for Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.listCustomDomainAssociations(crossinline block: ListCustomDomainAssociationsRequest.Builder.() -> Unit): ListCustomDomainAssociationsResponse = listCustomDomainAssociations(ListCustomDomainAssociationsRequest.Builder().apply(block).build())

/**
 * Returns an array of `EndpointAccess` objects and relevant information.
 */
public suspend inline fun RedshiftServerlessClient.listEndpointAccess(crossinline block: ListEndpointAccessRequest.Builder.() -> Unit): ListEndpointAccessResponse = listEndpointAccess(ListEndpointAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a list of specified namespaces.
 */
public suspend inline fun RedshiftServerlessClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit): ListNamespacesResponse = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Returns an array of recovery points.
 */
public suspend inline fun RedshiftServerlessClient.listRecoveryPoints(crossinline block: ListRecoveryPointsRequest.Builder.() -> Unit): ListRecoveryPointsResponse = listRecoveryPoints(ListRecoveryPointsRequest.Builder().apply(block).build())

/**
 * Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.
 */
public suspend inline fun RedshiftServerlessClient.listScheduledActions(crossinline block: ListScheduledActionsRequest.Builder.() -> Unit): ListScheduledActionsResponse = listScheduledActions(ListScheduledActionsRequest.Builder().apply(block).build())

/**
 * Returns a list of snapshot copy configurations.
 */
public suspend inline fun RedshiftServerlessClient.listSnapshotCopyConfigurations(crossinline block: ListSnapshotCopyConfigurationsRequest.Builder.() -> Unit): ListSnapshotCopyConfigurationsResponse = listSnapshotCopyConfigurations(ListSnapshotCopyConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of snapshots.
 */
public suspend inline fun RedshiftServerlessClient.listSnapshots(crossinline block: ListSnapshotsRequest.Builder.() -> Unit): ListSnapshotsResponse = listSnapshots(ListSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns information about an array of `TableRestoreStatus` objects.
 */
public suspend inline fun RedshiftServerlessClient.listTableRestoreStatus(crossinline block: ListTableRestoreStatusRequest.Builder.() -> Unit): ListTableRestoreStatusResponse = listTableRestoreStatus(ListTableRestoreStatusRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a resource.
 */
public suspend inline fun RedshiftServerlessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all usage limits within Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.listUsageLimits(crossinline block: ListUsageLimitsRequest.Builder.() -> Unit): ListUsageLimitsResponse = listUsageLimits(ListUsageLimitsRequest.Builder().apply(block).build())

/**
 * Returns information about a list of specified workgroups.
 */
public suspend inline fun RedshiftServerlessClient.listWorkgroups(crossinline block: ListWorkgroupsRequest.Builder.() -> Unit): ListWorkgroupsResponse = listWorkgroups(ListWorkgroupsRequest.Builder().apply(block).build())

/**
 * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
 */
public suspend inline fun RedshiftServerlessClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Restore the data from a recovery point.
 */
public suspend inline fun RedshiftServerlessClient.restoreFromRecoveryPoint(crossinline block: RestoreFromRecoveryPointRequest.Builder.() -> Unit): RestoreFromRecoveryPointResponse = restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest.Builder().apply(block).build())

/**
 * Restores a namespace from a snapshot.
 */
public suspend inline fun RedshiftServerlessClient.restoreFromSnapshot(crossinline block: RestoreFromSnapshotRequest.Builder.() -> Unit): RestoreFromSnapshotResponse = restoreFromSnapshot(RestoreFromSnapshotRequest.Builder().apply(block).build())

/**
 * Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with interleaved sort keys.
 */
public suspend inline fun RedshiftServerlessClient.restoreTableFromRecoveryPoint(crossinline block: RestoreTableFromRecoveryPointRequest.Builder.() -> Unit): RestoreTableFromRecoveryPointResponse = restoreTableFromRecoveryPoint(RestoreTableFromRecoveryPointRequest.Builder().apply(block).build())

/**
 * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with [interleaved sort keys](https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved).
 */
public suspend inline fun RedshiftServerlessClient.restoreTableFromSnapshot(crossinline block: RestoreTableFromSnapshotRequest.Builder.() -> Unit): RestoreTableFromSnapshotResponse = restoreTableFromSnapshot(RestoreTableFromSnapshotRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags to a resource.
 */
public suspend inline fun RedshiftServerlessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or set of tags from a resource.
 */
public suspend inline fun RedshiftServerlessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
 */
public suspend inline fun RedshiftServerlessClient.updateCustomDomainAssociation(crossinline block: UpdateCustomDomainAssociationRequest.Builder.() -> Unit): UpdateCustomDomainAssociationResponse = updateCustomDomainAssociation(UpdateCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Redshift Serverless managed endpoint.
 */
public suspend inline fun RedshiftServerlessClient.updateEndpointAccess(crossinline block: UpdateEndpointAccessRequest.Builder.() -> Unit): UpdateEndpointAccessResponse = updateEndpointAccess(UpdateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one request. For example, you must specify both `adminUsername` and `adminUserPassword` to update either field, but you can't update both `kmsKeyId` and `logExports` in a single request.
 */
public suspend inline fun RedshiftServerlessClient.updateNamespace(crossinline block: UpdateNamespaceRequest.Builder.() -> Unit): UpdateNamespaceResponse = updateNamespace(UpdateNamespaceRequest.Builder().apply(block).build())

/**
 * Updates a scheduled action.
 */
public suspend inline fun RedshiftServerlessClient.updateScheduledAction(crossinline block: UpdateScheduledActionRequest.Builder.() -> Unit): UpdateScheduledActionResponse = updateScheduledAction(UpdateScheduledActionRequest.Builder().apply(block).build())

/**
 * Updates a snapshot.
 */
public suspend inline fun RedshiftServerlessClient.updateSnapshot(crossinline block: UpdateSnapshotRequest.Builder.() -> Unit): UpdateSnapshotResponse = updateSnapshot(UpdateSnapshotRequest.Builder().apply(block).build())

/**
 * Updates a snapshot copy configuration.
 */
public suspend inline fun RedshiftServerlessClient.updateSnapshotCopyConfiguration(crossinline block: UpdateSnapshotCopyConfigurationRequest.Builder.() -> Unit): UpdateSnapshotCopyConfigurationResponse = updateSnapshotCopyConfiguration(UpdateSnapshotCopyConfigurationRequest.Builder().apply(block).build())

/**
 * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
 */
public suspend inline fun RedshiftServerlessClient.updateUsageLimit(crossinline block: UpdateUsageLimitRequest.Builder.() -> Unit): UpdateUsageLimitResponse = updateUsageLimit(UpdateUsageLimitRequest.Builder().apply(block).build())

/**
 * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one request. For example, you can update `baseCapacity` or `port` in a single request, but you can't update both in the same request.
 */
public suspend inline fun RedshiftServerlessClient.updateWorkgroup(crossinline block: UpdateWorkgroupRequest.Builder.() -> Unit): UpdateWorkgroupResponse = updateWorkgroup(UpdateWorkgroupRequest.Builder().apply(block).build())
