// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.redshiftserverless.model.Namespace
import aws.sdk.kotlin.services.redshiftserverless.model.RedshiftServerlessException
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RestoreFromSnapshotOperationDeserializer: HttpDeserialize<RestoreFromSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RestoreFromSnapshotResponse {
        if (!response.status.isSuccess()) {
            throwRestoreFromSnapshotError(context, response)
        }
        val builder = RestoreFromSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreFromSnapshotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRestoreFromSnapshotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftServerlessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreFromSnapshotOperationBody(builder: RestoreFromSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("namespace"))
    val OWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerAccount"))
    val SNAPSHOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("snapshotName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAMESPACE_DESCRIPTOR)
        field(OWNERACCOUNT_DESCRIPTOR)
        field(SNAPSHOTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAMESPACE_DESCRIPTOR.index -> builder.namespace = deserializeNamespaceDocument(deserializer)
                OWNERACCOUNT_DESCRIPTOR.index -> builder.ownerAccount = deserializeString()
                SNAPSHOTNAME_DESCRIPTOR.index -> builder.snapshotName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
