// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.redshiftserverless.model.GetRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RecoveryPoint
import aws.sdk.kotlin.services.redshiftserverless.model.RedshiftServerlessException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRecoveryPointOperationDeserializer: HttpDeserialize<GetRecoveryPointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRecoveryPointResponse {
        if (!response.status.isSuccess()) {
            throwGetRecoveryPointError(context, response)
        }
        val builder = GetRecoveryPointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRecoveryPointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRecoveryPointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftServerlessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecoveryPointOperationBody(builder: GetRecoveryPointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RECOVERYPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("recoveryPoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RECOVERYPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RECOVERYPOINT_DESCRIPTOR.index -> builder.recoveryPoint = deserializeRecoveryPointDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
