// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

class ListSnapshotsRequest private constructor(builder: Builder) {
    /**
     * The timestamp showing when the snapshot creation finished.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An optional parameter that specifies the maximum number of results to return. You can use `nextToken` to get the next page of results.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The Amazon Resource Name (ARN) of the namespace from which to list all snapshots.
     */
    val namespaceArn: kotlin.String? = builder.namespaceArn
    /**
     * The namespace from which to list all snapshots.
     */
    val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The owner Amazon Web Services account of the snapshot.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The time when the creation of the snapshot was initiated.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSnapshotsRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("namespaceArn=$namespaceArn,")
        append("namespaceName=$namespaceName,")
        append("nextToken=$nextToken,")
        append("ownerAccount=$ownerAccount,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespaceArn?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSnapshotsRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (namespaceArn != other.namespaceArn) return false
        if (namespaceName != other.namespaceName) return false
        if (nextToken != other.nextToken) return false
        if (ownerAccount != other.ownerAccount) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The timestamp showing when the snapshot creation finished.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional parameter that specifies the maximum number of results to return. You can use `nextToken` to get the next page of results.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the namespace from which to list all snapshots.
         */
        var namespaceArn: kotlin.String? = null
        /**
         * The namespace from which to list all snapshots.
         */
        var namespaceName: kotlin.String? = null
        /**
         * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
         */
        var nextToken: kotlin.String? = null
        /**
         * The owner Amazon Web Services account of the snapshot.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The time when the creation of the snapshot was initiated.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.namespaceArn = x.namespaceArn
            this.namespaceName = x.namespaceName
            this.nextToken = x.nextToken
            this.ownerAccount = x.ownerAccount
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest = ListSnapshotsRequest(this)
    }
}
