// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model



class CreateWorkgroupRequest private constructor(builder: Builder) {
    /**
     * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    val baseCapacity: kotlin.Int? = builder.baseCapacity
    /**
     * An array of parameters to set for more control over a serverless database. The options are `datestyle`, `enable_user_activity_logging`, `query_group`, `search_path`, and `max_query_execution_time`.
     */
    val configParameters: List<ConfigParameter>? = builder.configParameters
    /**
     * The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
     */
    val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * The name of the namespace to associate with the workgroup.
     */
    val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * A value that specifies whether the workgroup can be accessed from a public network.
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * An array of security group IDs to associate with the workgroup.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * An array of VPC subnet IDs to associate with the workgroup.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * A array of tag instances.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the created workgroup.
     */
    val workgroupName: kotlin.String? = builder.workgroupName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkgroupRequest(")
        append("baseCapacity=$baseCapacity,")
        append("configParameters=$configParameters,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("namespaceName=$namespaceName,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("workgroupName=$workgroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCapacity ?: 0
        result = 31 * result + (configParameters?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkgroupRequest

        if (baseCapacity != other.baseCapacity) return false
        if (configParameters != other.configParameters) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (namespaceName != other.namespaceName) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
         */
        var baseCapacity: kotlin.Int? = null
        /**
         * An array of parameters to set for more control over a serverless database. The options are `datestyle`, `enable_user_activity_logging`, `query_group`, `search_path`, and `max_query_execution_time`.
         */
        var configParameters: List<ConfigParameter>? = null
        /**
         * The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
         */
        var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * The name of the namespace to associate with the workgroup.
         */
        var namespaceName: kotlin.String? = null
        /**
         * A value that specifies whether the workgroup can be accessed from a public network.
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * An array of security group IDs to associate with the workgroup.
         */
        var securityGroupIds: List<String>? = null
        /**
         * An array of VPC subnet IDs to associate with the workgroup.
         */
        var subnetIds: List<String>? = null
        /**
         * A array of tag instances.
         */
        var tags: List<Tag>? = null
        /**
         * The name of the created workgroup.
         */
        var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupRequest) : this() {
            this.baseCapacity = x.baseCapacity
            this.configParameters = x.configParameters
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.namespaceName = x.namespaceName
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupRequest = CreateWorkgroupRequest(this)
    }
}
