// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.redshiftserverless.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.redshiftserverless.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift Serverless.
 *
 * Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift Serverless lets you focus on using your data to acquire new insights for your business and customers.
 *
 *  To learn more about Amazon Redshift Serverless, see [What is Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html).
 */
interface RedshiftServerlessClient : SdkClient {

    override val serviceName: String
        get() = "Redshift Serverless"
    /**
     * RedshiftServerlessClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): RedshiftServerlessClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRedshiftServerlessClient(config)
        }

        operator fun invoke(config: Config): RedshiftServerlessClient = DefaultRedshiftServerlessClient(config)

        /**
         * Construct a [RedshiftServerlessClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RedshiftServerlessClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRedshiftServerlessClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    suspend fun convertRecoveryPointToSnapshot(input: ConvertRecoveryPointToSnapshotRequest): ConvertRecoveryPointToSnapshotResponse

    /**
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     */
    suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse

    /**
     * Creates a namespace in Amazon Redshift Serverless.
     */
    suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse

    /**
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
     */
    suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse

    /**
     * Creates an workgroup in Amazon Redshift Serverless.
     */
    suspend fun createWorkgroup(input: CreateWorkgroupRequest): CreateWorkgroupResponse

    /**
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     */
    suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse

    /**
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
     */
    suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes the specified resource policy.
     */
    suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a snapshot from Amazon Redshift Serverless.
     */
    suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes a usage limit from Amazon Redshift Serverless.
     */
    suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse

    /**
     * Deletes a workgroup.
     */
    suspend fun deleteWorkgroup(input: DeleteWorkgroupRequest): DeleteWorkgroupResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
     *
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
     *
     *  The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
     *
     *  If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
     */
    suspend fun getCredentials(input: GetCredentialsRequest): GetCredentialsResponse

    /**
     * Returns information, such as the name, about a VPC endpoint.
     */
    suspend fun getEndpointAccess(input: GetEndpointAccessRequest): GetEndpointAccessResponse

    /**
     * Returns information about a namespace in Amazon Redshift Serverless.
     */
    suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse

    /**
     * Returns information about a recovery point.
     */
    suspend fun getRecoveryPoint(input: GetRecoveryPointRequest): GetRecoveryPointResponse

    /**
     * Returns a resource policy.
     */
    suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Returns information about a specific snapshot.
     */
    suspend fun getSnapshot(input: GetSnapshotRequest = GetSnapshotRequest {}): GetSnapshotResponse

    /**
     * Returns information about a usage limit.
     */
    suspend fun getUsageLimit(input: GetUsageLimitRequest): GetUsageLimitResponse

    /**
     * Returns information about a specific workgroup.
     */
    suspend fun getWorkgroup(input: GetWorkgroupRequest): GetWorkgroupResponse

    /**
     * Returns an array of `EndpointAccess` objects and relevant information.
     */
    suspend fun listEndpointAccess(input: ListEndpointAccessRequest = ListEndpointAccessRequest {}): ListEndpointAccessResponse

    /**
     * Returns information about a list of specified namespaces.
     */
    suspend fun listNamespaces(input: ListNamespacesRequest = ListNamespacesRequest {}): ListNamespacesResponse

    /**
     * Returns an array of recovery points.
     */
    suspend fun listRecoveryPoints(input: ListRecoveryPointsRequest = ListRecoveryPointsRequest {}): ListRecoveryPointsResponse

    /**
     * Returns a list of snapshots.
     */
    suspend fun listSnapshots(input: ListSnapshotsRequest = ListSnapshotsRequest {}): ListSnapshotsResponse

    /**
     * Lists the tags assigned to a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all usage limits within Amazon Redshift Serverless.
     */
    suspend fun listUsageLimits(input: ListUsageLimitsRequest = ListUsageLimitsRequest {}): ListUsageLimitsResponse

    /**
     * Returns information about a list of specified workgroups.
     */
    suspend fun listWorkgroups(input: ListWorkgroupsRequest = ListWorkgroupsRequest {}): ListWorkgroupsResponse

    /**
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
     */
    suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Restore the data from a recovery point.
     */
    suspend fun restoreFromRecoveryPoint(input: RestoreFromRecoveryPointRequest): RestoreFromRecoveryPointResponse

    /**
     * Restores a namespace from a snapshot.
     */
    suspend fun restoreFromSnapshot(input: RestoreFromSnapshotRequest): RestoreFromSnapshotResponse

    /**
     * Assigns one or more tags to a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or set of tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon Redshift Serverless managed endpoint.
     */
    suspend fun updateEndpointAccess(input: UpdateEndpointAccessRequest): UpdateEndpointAccessResponse

    /**
     * Updates a namespace with the specified settings.
     */
    suspend fun updateNamespace(input: UpdateNamespaceRequest): UpdateNamespaceResponse

    /**
     * Updates a snapshot.
     */
    suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse

    /**
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     */
    suspend fun updateUsageLimit(input: UpdateUsageLimitRequest): UpdateUsageLimitResponse

    /**
     * Updates a workgroup with the specified configuration settings.
     */
    suspend fun updateWorkgroup(input: UpdateWorkgroupRequest): UpdateWorkgroupResponse
}

/**
 * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
 */
suspend inline fun RedshiftServerlessClient.convertRecoveryPointToSnapshot(crossinline block: ConvertRecoveryPointToSnapshotRequest.Builder.() -> Unit) = convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Redshift Serverless managed VPC endpoint.
 */
suspend inline fun RedshiftServerlessClient.createEndpointAccess(crossinline block: CreateEndpointAccessRequest.Builder.() -> Unit) = createEndpointAccess(CreateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Creates a namespace in Amazon Redshift Serverless.
 */
suspend inline fun RedshiftServerlessClient.createNamespace(crossinline block: CreateNamespaceRequest.Builder.() -> Unit) = createNamespace(CreateNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
 */
suspend inline fun RedshiftServerlessClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit) = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
 */
suspend inline fun RedshiftServerlessClient.createUsageLimit(crossinline block: CreateUsageLimitRequest.Builder.() -> Unit) = createUsageLimit(CreateUsageLimitRequest.Builder().apply(block).build())

/**
 * Creates an workgroup in Amazon Redshift Serverless.
 */
suspend inline fun RedshiftServerlessClient.createWorkgroup(crossinline block: CreateWorkgroupRequest.Builder.() -> Unit) = createWorkgroup(CreateWorkgroupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Redshift Serverless managed VPC endpoint.
 */
suspend inline fun RedshiftServerlessClient.deleteEndpointAccess(crossinline block: DeleteEndpointAccessRequest.Builder.() -> Unit) = deleteEndpointAccess(DeleteEndpointAccessRequest.Builder().apply(block).build())

/**
 * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
 */
suspend inline fun RedshiftServerlessClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit) = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource policy.
 */
suspend inline fun RedshiftServerlessClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit) = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot from Amazon Redshift Serverless.
 */
suspend inline fun RedshiftServerlessClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit) = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a usage limit from Amazon Redshift Serverless.
 */
suspend inline fun RedshiftServerlessClient.deleteUsageLimit(crossinline block: DeleteUsageLimitRequest.Builder.() -> Unit) = deleteUsageLimit(DeleteUsageLimitRequest.Builder().apply(block).build())

/**
 * Deletes a workgroup.
 */
suspend inline fun RedshiftServerlessClient.deleteWorkgroup(crossinline block: DeleteWorkgroupRequest.Builder.() -> Unit) = deleteWorkgroup(DeleteWorkgroupRequest.Builder().apply(block).build())

/**
 * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
 *
 * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
 *
 *  The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
 *
 *  If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
 */
suspend inline fun RedshiftServerlessClient.getCredentials(crossinline block: GetCredentialsRequest.Builder.() -> Unit) = getCredentials(GetCredentialsRequest.Builder().apply(block).build())

/**
 * Returns information, such as the name, about a VPC endpoint.
 */
suspend inline fun RedshiftServerlessClient.getEndpointAccess(crossinline block: GetEndpointAccessRequest.Builder.() -> Unit) = getEndpointAccess(GetEndpointAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a namespace in Amazon Redshift Serverless.
 */
suspend inline fun RedshiftServerlessClient.getNamespace(crossinline block: GetNamespaceRequest.Builder.() -> Unit) = getNamespace(GetNamespaceRequest.Builder().apply(block).build())

/**
 * Returns information about a recovery point.
 */
suspend inline fun RedshiftServerlessClient.getRecoveryPoint(crossinline block: GetRecoveryPointRequest.Builder.() -> Unit) = getRecoveryPoint(GetRecoveryPointRequest.Builder().apply(block).build())

/**
 * Returns a resource policy.
 */
suspend inline fun RedshiftServerlessClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit) = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns information about a specific snapshot.
 */
suspend inline fun RedshiftServerlessClient.getSnapshot(crossinline block: GetSnapshotRequest.Builder.() -> Unit) = getSnapshot(GetSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about a usage limit.
 */
suspend inline fun RedshiftServerlessClient.getUsageLimit(crossinline block: GetUsageLimitRequest.Builder.() -> Unit) = getUsageLimit(GetUsageLimitRequest.Builder().apply(block).build())

/**
 * Returns information about a specific workgroup.
 */
suspend inline fun RedshiftServerlessClient.getWorkgroup(crossinline block: GetWorkgroupRequest.Builder.() -> Unit) = getWorkgroup(GetWorkgroupRequest.Builder().apply(block).build())

/**
 * Returns an array of `EndpointAccess` objects and relevant information.
 */
suspend inline fun RedshiftServerlessClient.listEndpointAccess(crossinline block: ListEndpointAccessRequest.Builder.() -> Unit) = listEndpointAccess(ListEndpointAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a list of specified namespaces.
 */
suspend inline fun RedshiftServerlessClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit) = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Returns an array of recovery points.
 */
suspend inline fun RedshiftServerlessClient.listRecoveryPoints(crossinline block: ListRecoveryPointsRequest.Builder.() -> Unit) = listRecoveryPoints(ListRecoveryPointsRequest.Builder().apply(block).build())

/**
 * Returns a list of snapshots.
 */
suspend inline fun RedshiftServerlessClient.listSnapshots(crossinline block: ListSnapshotsRequest.Builder.() -> Unit) = listSnapshots(ListSnapshotsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a resource.
 */
suspend inline fun RedshiftServerlessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all usage limits within Amazon Redshift Serverless.
 */
suspend inline fun RedshiftServerlessClient.listUsageLimits(crossinline block: ListUsageLimitsRequest.Builder.() -> Unit) = listUsageLimits(ListUsageLimitsRequest.Builder().apply(block).build())

/**
 * Returns information about a list of specified workgroups.
 */
suspend inline fun RedshiftServerlessClient.listWorkgroups(crossinline block: ListWorkgroupsRequest.Builder.() -> Unit) = listWorkgroups(ListWorkgroupsRequest.Builder().apply(block).build())

/**
 * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
 */
suspend inline fun RedshiftServerlessClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit) = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Restore the data from a recovery point.
 */
suspend inline fun RedshiftServerlessClient.restoreFromRecoveryPoint(crossinline block: RestoreFromRecoveryPointRequest.Builder.() -> Unit) = restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest.Builder().apply(block).build())

/**
 * Restores a namespace from a snapshot.
 */
suspend inline fun RedshiftServerlessClient.restoreFromSnapshot(crossinline block: RestoreFromSnapshotRequest.Builder.() -> Unit) = restoreFromSnapshot(RestoreFromSnapshotRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags to a resource.
 */
suspend inline fun RedshiftServerlessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or set of tags from a resource.
 */
suspend inline fun RedshiftServerlessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Redshift Serverless managed endpoint.
 */
suspend inline fun RedshiftServerlessClient.updateEndpointAccess(crossinline block: UpdateEndpointAccessRequest.Builder.() -> Unit) = updateEndpointAccess(UpdateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Updates a namespace with the specified settings.
 */
suspend inline fun RedshiftServerlessClient.updateNamespace(crossinline block: UpdateNamespaceRequest.Builder.() -> Unit) = updateNamespace(UpdateNamespaceRequest.Builder().apply(block).build())

/**
 * Updates a snapshot.
 */
suspend inline fun RedshiftServerlessClient.updateSnapshot(crossinline block: UpdateSnapshotRequest.Builder.() -> Unit) = updateSnapshot(UpdateSnapshotRequest.Builder().apply(block).build())

/**
 * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
 */
suspend inline fun RedshiftServerlessClient.updateUsageLimit(crossinline block: UpdateUsageLimitRequest.Builder.() -> Unit) = updateUsageLimit(UpdateUsageLimitRequest.Builder().apply(block).build())

/**
 * Updates a workgroup with the specified configuration settings.
 */
suspend inline fun RedshiftServerlessClient.updateWorkgroup(crossinline block: UpdateWorkgroupRequest.Builder.() -> Unit) = updateWorkgroup(UpdateWorkgroupRequest.Builder().apply(block).build())
