// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.AuthorizationStatus
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class RevokeEndpointAccessOperationDeserializer: HttpDeserialize<RevokeEndpointAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RevokeEndpointAccessResponse {
        if (!response.status.isSuccess()) {
            throwRevokeEndpointAccessError(context, response)
        }
        val builder = RevokeEndpointAccessResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRevokeEndpointAccessOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeRevokeEndpointAccessOperationBody(builder: RevokeEndpointAccessResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RevokeEndpointAccessResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RevokeEndpointAccessResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RevokeEndpointAccess response")
    }

    val ALLOWEDALLVPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("AllowedAllVPCs"))
    val ALLOWEDVPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AllowedVPCs"), XmlCollectionName("VpcIdentifier"))
    val AUTHORIZETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("AuthorizeTime"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterIdentifier"))
    val CLUSTERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterStatus"))
    val ENDPOINTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("EndpointCount"))
    val GRANTEE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Grantee"))
    val GRANTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Grantor"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("RevokeEndpointAccessResult"))
        field(ALLOWEDALLVPCS_DESCRIPTOR)
        field(ALLOWEDVPCS_DESCRIPTOR)
        field(AUTHORIZETIME_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CLUSTERSTATUS_DESCRIPTOR)
        field(ENDPOINTCOUNT_DESCRIPTOR)
        field(GRANTEE_DESCRIPTOR)
        field(GRANTOR_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWEDALLVPCS_DESCRIPTOR.index -> builder.allowedAllVpCs = deserializeBoolean()
                ALLOWEDVPCS_DESCRIPTOR.index -> builder.allowedVpCs =
                    deserializer.deserializeList(ALLOWEDVPCS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHORIZETIME_DESCRIPTOR.index -> builder.authorizeTime = deserializeString().let { Instant.fromIso8601(it) }
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CLUSTERSTATUS_DESCRIPTOR.index -> builder.clusterStatus = deserializeString()
                ENDPOINTCOUNT_DESCRIPTOR.index -> builder.endpointCount = deserializeInt()
                GRANTEE_DESCRIPTOR.index -> builder.grantee = deserializeString()
                GRANTOR_DESCRIPTOR.index -> builder.grantor = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AuthorizationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwRevokeEndpointAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer()
        "EndpointAuthorizationNotFound" -> EndpointAuthorizationNotFoundFaultDeserializer()
        "EndpointNotFound" -> EndpointNotFoundFaultDeserializer()
        "InvalidAuthorizationState" -> InvalidAuthorizationStateFaultDeserializer()
        "InvalidClusterSecurityGroupState" -> InvalidClusterSecurityGroupStateFaultDeserializer()
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer()
        "InvalidEndpointState" -> InvalidEndpointStateFaultDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
