// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.ResizeClusterRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ResizeClusterOperationSerializer: HttpSerialize<ResizeClusterRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ResizeClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeResizeClusterOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeResizeClusterOperationBody(context: ExecutionContext, input: ResizeClusterRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CLASSIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Classic"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClusterIdentifier"))
    val CLUSTERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClusterType"))
    val NODETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NodeType"))
    val NUMBEROFNODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("NumberOfNodes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ResizeClusterMessage"))
        trait(QueryLiteral("Action", "ResizeCluster"))
        trait(QueryLiteral("Version", "2012-12-01"))
        field(CLASSIC_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CLUSTERTYPE_DESCRIPTOR)
        field(NODETYPE_DESCRIPTOR)
        field(NUMBEROFNODES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.classic?.let { field(CLASSIC_DESCRIPTOR, it) }
        input.clusterIdentifier?.let { field(CLUSTERIDENTIFIER_DESCRIPTOR, it) }
        input.clusterType?.let { field(CLUSTERTYPE_DESCRIPTOR, it) }
        input.nodeType?.let { field(NODETYPE_DESCRIPTOR, it) }
        input.numberOfNodes?.let { field(NUMBEROFNODES_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
