// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ScheduledActionState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class ModifyScheduledActionOperationDeserializer: HttpDeserialize<ModifyScheduledActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyScheduledActionResponse {
        if (!response.status.isSuccess()) {
            throwModifyScheduledActionError(context, response)
        }
        val builder = ModifyScheduledActionResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyScheduledActionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeModifyScheduledActionOperationBody(builder: ModifyScheduledActionResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyScheduledActionResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyScheduledActionResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyScheduledAction response")
    }

    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("EndTime"))
    val IAMROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("IamRole"))
    val NEXTINVOCATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("NextInvocations"), XmlCollectionName("ScheduledActionTime"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Schedule"))
    val SCHEDULEDACTIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ScheduledActionDescription"))
    val SCHEDULEDACTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ScheduledActionName"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("StartTime"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("State"))
    val TARGETACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("TargetAction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("ModifyScheduledActionResult"))
        field(ENDTIME_DESCRIPTOR)
        field(IAMROLE_DESCRIPTOR)
        field(NEXTINVOCATIONS_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SCHEDULEDACTIONDESCRIPTION_DESCRIPTOR)
        field(SCHEDULEDACTIONNAME_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TARGETACTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromIso8601(it) }
                IAMROLE_DESCRIPTOR.index -> builder.iamRole = deserializeString()
                NEXTINVOCATIONS_DESCRIPTOR.index -> builder.nextInvocations =
                    deserializer.deserializeList(NEXTINVOCATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Instant>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Instant.fromIso8601(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeString()
                SCHEDULEDACTIONDESCRIPTION_DESCRIPTOR.index -> builder.scheduledActionDescription = deserializeString()
                SCHEDULEDACTIONNAME_DESCRIPTOR.index -> builder.scheduledActionName = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromIso8601(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ScheduledActionState.fromValue(it) }
                TARGETACTION_DESCRIPTOR.index -> builder.targetAction = deserializeScheduledActionTypeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwModifyScheduledActionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidScheduledAction" -> InvalidScheduledActionFaultDeserializer()
        "InvalidSchedule" -> InvalidScheduleFaultDeserializer()
        "ScheduledActionNotFound" -> ScheduledActionNotFoundFaultDeserializer()
        "ScheduledActionTypeUnsupported" -> ScheduledActionTypeUnsupportedFaultDeserializer()
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
