// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.VpcSecurityGroupMembership
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class ModifyEndpointAccessOperationDeserializer: HttpDeserialize<ModifyEndpointAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyEndpointAccessResponse {
        if (!response.status.isSuccess()) {
            throwModifyEndpointAccessError(context, response)
        }
        val builder = ModifyEndpointAccessResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyEndpointAccessOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeModifyEndpointAccessOperationBody(builder: ModifyEndpointAccessResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyEndpointAccessResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyEndpointAccessResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyEndpointAccess response")
    }

    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Address"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterIdentifier"))
    val ENDPOINTCREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("EndpointCreateTime"))
    val ENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointName"))
    val ENDPOINTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointStatus"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("Port"))
    val RESOURCEOWNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ResourceOwner"))
    val SUBNETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SubnetGroupName"))
    val VPCENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("VpcEndpoint"))
    val VPCSECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("VpcSecurityGroups"), XmlCollectionName("VpcSecurityGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("ModifyEndpointAccessResult"))
        field(ADDRESS_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(ENDPOINTCREATETIME_DESCRIPTOR)
        field(ENDPOINTNAME_DESCRIPTOR)
        field(ENDPOINTSTATUS_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(RESOURCEOWNER_DESCRIPTOR)
        field(SUBNETGROUPNAME_DESCRIPTOR)
        field(VPCENDPOINT_DESCRIPTOR)
        field(VPCSECURITYGROUPS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDRESS_DESCRIPTOR.index -> builder.address = deserializeString()
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                ENDPOINTCREATETIME_DESCRIPTOR.index -> builder.endpointCreateTime = deserializeString().let { Instant.fromIso8601(it) }
                ENDPOINTNAME_DESCRIPTOR.index -> builder.endpointName = deserializeString()
                ENDPOINTSTATUS_DESCRIPTOR.index -> builder.endpointStatus = deserializeString()
                PORT_DESCRIPTOR.index -> builder.port = deserializeInt()
                RESOURCEOWNER_DESCRIPTOR.index -> builder.resourceOwner = deserializeString()
                SUBNETGROUPNAME_DESCRIPTOR.index -> builder.subnetGroupName = deserializeString()
                VPCENDPOINT_DESCRIPTOR.index -> builder.vpcEndpoint = deserializeVpcEndpointDocument(deserializer)
                VPCSECURITYGROUPS_DESCRIPTOR.index -> builder.vpcSecurityGroups =
                    deserializer.deserializeList(VPCSECURITYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcSecurityGroupMembership>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcSecurityGroupMembershipDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwModifyEndpointAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer()
        "EndpointNotFound" -> EndpointNotFoundFaultDeserializer()
        "InvalidClusterSecurityGroupState" -> InvalidClusterSecurityGroupStateFaultDeserializer()
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer()
        "InvalidEndpointState" -> InvalidEndpointStateFaultDeserializer()
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
