// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DescribeResizeResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeResizeOperationDeserializer: HttpDeserialize<DescribeResizeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeResizeResponse {
        if (!response.status.isSuccess()) {
            throwDescribeResizeError(context, response)
        }
        val builder = DescribeResizeResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeResizeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeResizeOperationBody(builder: DescribeResizeResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeResizeResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeResizeResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeResize response")
    }

    val AVGRESIZERATEINMEGABYTESPERSECOND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, XmlSerialName("AvgResizeRateInMegaBytesPerSecond"))
    val DATATRANSFERPROGRESSPERCENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, XmlSerialName("DataTransferProgressPercent"))
    val ELAPSEDTIMEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("ElapsedTimeInSeconds"))
    val ESTIMATEDTIMETOCOMPLETIONINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("EstimatedTimeToCompletionInSeconds"))
    val IMPORTTABLESCOMPLETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ImportTablesCompleted"))
    val IMPORTTABLESINPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ImportTablesInProgress"))
    val IMPORTTABLESNOTSTARTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ImportTablesNotStarted"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Message"))
    val PROGRESSINMEGABYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("ProgressInMegaBytes"))
    val RESIZETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ResizeType"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val TARGETCLUSTERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TargetClusterType"))
    val TARGETENCRYPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TargetEncryptionType"))
    val TARGETNODETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TargetNodeType"))
    val TARGETNUMBEROFNODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("TargetNumberOfNodes"))
    val TOTALRESIZEDATAINMEGABYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("TotalResizeDataInMegaBytes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DescribeResizeResult"))
        field(AVGRESIZERATEINMEGABYTESPERSECOND_DESCRIPTOR)
        field(DATATRANSFERPROGRESSPERCENT_DESCRIPTOR)
        field(ELAPSEDTIMEINSECONDS_DESCRIPTOR)
        field(ESTIMATEDTIMETOCOMPLETIONINSECONDS_DESCRIPTOR)
        field(IMPORTTABLESCOMPLETED_DESCRIPTOR)
        field(IMPORTTABLESINPROGRESS_DESCRIPTOR)
        field(IMPORTTABLESNOTSTARTED_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(PROGRESSINMEGABYTES_DESCRIPTOR)
        field(RESIZETYPE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETCLUSTERTYPE_DESCRIPTOR)
        field(TARGETENCRYPTIONTYPE_DESCRIPTOR)
        field(TARGETNODETYPE_DESCRIPTOR)
        field(TARGETNUMBEROFNODES_DESCRIPTOR)
        field(TOTALRESIZEDATAINMEGABYTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVGRESIZERATEINMEGABYTESPERSECOND_DESCRIPTOR.index -> builder.avgResizeRateInMegaBytesPerSecond = deserializeDouble()
                DATATRANSFERPROGRESSPERCENT_DESCRIPTOR.index -> builder.dataTransferProgressPercent = deserializeDouble()
                ELAPSEDTIMEINSECONDS_DESCRIPTOR.index -> builder.elapsedTimeInSeconds = deserializeLong()
                ESTIMATEDTIMETOCOMPLETIONINSECONDS_DESCRIPTOR.index -> builder.estimatedTimeToCompletionInSeconds = deserializeLong()
                IMPORTTABLESCOMPLETED_DESCRIPTOR.index -> builder.importTablesCompleted =
                    deserializer.deserializeList(IMPORTTABLESCOMPLETED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMPORTTABLESINPROGRESS_DESCRIPTOR.index -> builder.importTablesInProgress =
                    deserializer.deserializeList(IMPORTTABLESINPROGRESS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMPORTTABLESNOTSTARTED_DESCRIPTOR.index -> builder.importTablesNotStarted =
                    deserializer.deserializeList(IMPORTTABLESNOTSTARTED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                PROGRESSINMEGABYTES_DESCRIPTOR.index -> builder.progressInMegaBytes = deserializeLong()
                RESIZETYPE_DESCRIPTOR.index -> builder.resizeType = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TARGETCLUSTERTYPE_DESCRIPTOR.index -> builder.targetClusterType = deserializeString()
                TARGETENCRYPTIONTYPE_DESCRIPTOR.index -> builder.targetEncryptionType = deserializeString()
                TARGETNODETYPE_DESCRIPTOR.index -> builder.targetNodeType = deserializeString()
                TARGETNUMBEROFNODES_DESCRIPTOR.index -> builder.targetNumberOfNodes = deserializeInt()
                TOTALRESIZEDATAINMEGABYTES_DESCRIPTOR.index -> builder.totalResizeDataInMegaBytes = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeResizeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer()
        "ResizeNotFound" -> ResizeNotFoundFaultDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
