// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeLoggingStatusOperationDeserializer: HttpDeserialize<DescribeLoggingStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLoggingStatusResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLoggingStatusError(context, response)
        }
        val builder = DescribeLoggingStatusResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLoggingStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeLoggingStatusOperationBody(builder: DescribeLoggingStatusResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeLoggingStatusResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeLoggingStatusResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeLoggingStatus response")
    }

    val BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("BucketName"))
    val LASTFAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("LastFailureMessage"))
    val LASTFAILURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("LastFailureTime"))
    val LASTSUCCESSFULDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("LastSuccessfulDeliveryTime"))
    val LOGGINGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("LoggingEnabled"))
    val S3KEYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("S3KeyPrefix"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DescribeLoggingStatusResult"))
        field(BUCKETNAME_DESCRIPTOR)
        field(LASTFAILUREMESSAGE_DESCRIPTOR)
        field(LASTFAILURETIME_DESCRIPTOR)
        field(LASTSUCCESSFULDELIVERYTIME_DESCRIPTOR)
        field(LOGGINGENABLED_DESCRIPTOR)
        field(S3KEYPREFIX_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUCKETNAME_DESCRIPTOR.index -> builder.bucketName = deserializeString()
                LASTFAILUREMESSAGE_DESCRIPTOR.index -> builder.lastFailureMessage = deserializeString()
                LASTFAILURETIME_DESCRIPTOR.index -> builder.lastFailureTime = deserializeString().let { Instant.fromIso8601(it) }
                LASTSUCCESSFULDELIVERYTIME_DESCRIPTOR.index -> builder.lastSuccessfulDeliveryTime = deserializeString().let { Instant.fromIso8601(it) }
                LOGGINGENABLED_DESCRIPTOR.index -> builder.loggingEnabled = deserializeBoolean()
                S3KEYPREFIX_DESCRIPTOR.index -> builder.s3KeyPrefix = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeLoggingStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
