// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.AccountAttribute
import aws.sdk.kotlin.services.redshift.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeAccountAttributesOperationDeserializer: HttpDeserialize<DescribeAccountAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAccountAttributesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAccountAttributesError(context, response)
        }
        val builder = DescribeAccountAttributesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccountAttributesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeAccountAttributesOperationBody(builder: DescribeAccountAttributesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeAccountAttributesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeAccountAttributesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeAccountAttributes response")
    }

    val ACCOUNTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AccountAttributes"), XmlCollectionName("AccountAttribute"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("DescribeAccountAttributesResult"))
        field(ACCOUNTATTRIBUTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTATTRIBUTES_DESCRIPTOR.index -> builder.accountAttributes =
                    deserializer.deserializeList(ACCOUNTATTRIBUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<AccountAttribute>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAccountAttributeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeAccountAttributesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw RedshiftException(errorDetails.message)
}
