// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateSnapshotCopyGrantOperationDeserializer: HttpDeserialize<CreateSnapshotCopyGrantResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateSnapshotCopyGrantResponse {
        if (!response.status.isSuccess()) {
            throwCreateSnapshotCopyGrantError(context, response)
        }
        val builder = CreateSnapshotCopyGrantResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSnapshotCopyGrantOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateSnapshotCopyGrantOperationBody(builder: CreateSnapshotCopyGrantResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateSnapshotCopyGrantResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateSnapshotCopyGrantResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateSnapshotCopyGrant response")
    }

    val SNAPSHOTCOPYGRANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("SnapshotCopyGrant"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("CreateSnapshotCopyGrantResult"))
        field(SNAPSHOTCOPYGRANT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SNAPSHOTCOPYGRANT_DESCRIPTOR.index -> builder.snapshotCopyGrant = deserializeSnapshotCopyGrantDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateSnapshotCopyGrantError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer()
        "InvalidTagFault" -> InvalidTagFaultDeserializer()
        "LimitExceededFault" -> LimitExceededFaultDeserializer()
        "SnapshotCopyGrantAlreadyExistsFault" -> SnapshotCopyGrantAlreadyExistsFaultDeserializer()
        "SnapshotCopyGrantQuotaExceededFault" -> SnapshotCopyGrantQuotaExceededFaultDeserializer()
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
