// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.redshift.model.CreateAuthenticationProfileResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateAuthenticationProfileOperationDeserializer: HttpDeserialize<CreateAuthenticationProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateAuthenticationProfileResponse {
        if (!response.status.isSuccess()) {
            throwCreateAuthenticationProfileError(context, response)
        }
        val builder = CreateAuthenticationProfileResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAuthenticationProfileOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateAuthenticationProfileOperationBody(builder: CreateAuthenticationProfileResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateAuthenticationProfileResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateAuthenticationProfileResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateAuthenticationProfile response")
    }

    val AUTHENTICATIONPROFILECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AuthenticationProfileContent"))
    val AUTHENTICATIONPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AuthenticationProfileName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("CreateAuthenticationProfileResult"))
        field(AUTHENTICATIONPROFILECONTENT_DESCRIPTOR)
        field(AUTHENTICATIONPROFILENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONPROFILECONTENT_DESCRIPTOR.index -> builder.authenticationProfileContent = deserializeString()
                AUTHENTICATIONPROFILENAME_DESCRIPTOR.index -> builder.authenticationProfileName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateAuthenticationProfileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AuthenticationProfileAlreadyExistsFault" -> AuthenticationProfileAlreadyExistsFaultDeserializer()
        "AuthenticationProfileQuotaExceededFault" -> AuthenticationProfileQuotaExceededFaultDeserializer()
        "InvalidAuthenticationProfileRequestFault" -> InvalidAuthenticationProfileRequestFaultDeserializer()
        else -> throw RedshiftException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
