// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a usage limit object for a cluster.
 */
class UsageLimit private constructor(builder: BuilderImpl) {
    /**
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
     */
    val amount: Long = builder.amount
    /**
     * The action that Amazon Redshift takes when the limit is reached. Possible values are:
     * log - To log an event in a system table. The default is log.
     * emit-metric - To emit CloudWatch metrics.
     * disable - To disable the feature until the next usage period begins.
     */
    val breachAction: UsageLimitBreachAction? = builder.breachAction
    /**
     * The identifier of the cluster with a usage limit.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The Amazon Redshift feature to which the limit applies.
     */
    val featureType: UsageLimitFeatureType? = builder.featureType
    /**
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     */
    val limitType: UsageLimitLimitType? = builder.limitType
    /**
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     */
    val period: UsageLimitPeriod? = builder.period
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the usage limit.
     */
    val usageLimitId: String? = builder.usageLimitId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsageLimit = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsageLimit(")
        append("amount=$amount,")
        append("breachAction=$breachAction,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("featureType=$featureType,")
        append("limitType=$limitType,")
        append("period=$period,")
        append("tags=$tags,")
        append("usageLimitId=$usageLimitId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amount.hashCode()
        result = 31 * result + (breachAction?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (featureType?.hashCode() ?: 0)
        result = 31 * result + (limitType?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usageLimitId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsageLimit

        if (amount != other.amount) return false
        if (breachAction != other.breachAction) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (featureType != other.featureType) return false
        if (limitType != other.limitType) return false
        if (period != other.period) return false
        if (tags != other.tags) return false
        if (usageLimitId != other.usageLimitId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsageLimit = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsageLimit
        /**
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
         */
        fun amount(amount: Long): FluentBuilder
        /**
         * The action that Amazon Redshift takes when the limit is reached. Possible values are:
         * log - To log an event in a system table. The default is log.
         * emit-metric - To emit CloudWatch metrics.
         * disable - To disable the feature until the next usage period begins.
         */
        fun breachAction(breachAction: UsageLimitBreachAction): FluentBuilder
        /**
         * The identifier of the cluster with a usage limit.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The Amazon Redshift feature to which the limit applies.
         */
        fun featureType(featureType: UsageLimitFeatureType): FluentBuilder
        /**
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         */
        fun limitType(limitType: UsageLimitLimitType): FluentBuilder
        /**
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         */
        fun period(period: UsageLimitPeriod): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The identifier of the usage limit.
         */
        fun usageLimitId(usageLimitId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
         */
        var amount: Long
        /**
         * The action that Amazon Redshift takes when the limit is reached. Possible values are:
         * log - To log an event in a system table. The default is log.
         * emit-metric - To emit CloudWatch metrics.
         * disable - To disable the feature until the next usage period begins.
         */
        var breachAction: UsageLimitBreachAction?
        /**
         * The identifier of the cluster with a usage limit.
         */
        var clusterIdentifier: String?
        /**
         * The Amazon Redshift feature to which the limit applies.
         */
        var featureType: UsageLimitFeatureType?
        /**
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         */
        var limitType: UsageLimitLimitType?
        /**
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         */
        var period: UsageLimitPeriod?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?
        /**
         * The identifier of the usage limit.
         */
        var usageLimitId: String?

        fun build(): UsageLimit
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amount: Long = 0L
        override var breachAction: UsageLimitBreachAction? = null
        override var clusterIdentifier: String? = null
        override var featureType: UsageLimitFeatureType? = null
        override var limitType: UsageLimitLimitType? = null
        override var period: UsageLimitPeriod? = null
        override var tags: List<Tag>? = null
        override var usageLimitId: String? = null

        constructor(x: UsageLimit) : this() {
            this.amount = x.amount
            this.breachAction = x.breachAction
            this.clusterIdentifier = x.clusterIdentifier
            this.featureType = x.featureType
            this.limitType = x.limitType
            this.period = x.period
            this.tags = x.tags
            this.usageLimitId = x.usageLimitId
        }

        override fun build(): UsageLimit = UsageLimit(this)
        override fun amount(amount: Long): FluentBuilder = apply { this.amount = amount }
        override fun breachAction(breachAction: UsageLimitBreachAction): FluentBuilder = apply { this.breachAction = breachAction }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun featureType(featureType: UsageLimitFeatureType): FluentBuilder = apply { this.featureType = featureType }
        override fun limitType(limitType: UsageLimitLimitType): FluentBuilder = apply { this.limitType = limitType }
        override fun period(period: UsageLimitPeriod): FluentBuilder = apply { this.period = period }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun usageLimitId(usageLimitId: String): FluentBuilder = apply { this.usageLimitId = usageLimitId }
    }
}
