// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * A tag and its associated resource.
 */
class TaggedResource private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) with which the tag is associated, for example:
     * arn:aws:redshift:us-east-2:123456789:cluster:t1.
     */
    val resourceName: String? = builder.resourceName
    /**
     * The type of resource with which the tag is associated. Valid resource types are:
     * Cluster
     * CIDR/IP
     * EC2 security group
     * Snapshot
     * Cluster security group
     * Subnet group
     * HSM connection
     * HSM certificate
     * Parameter group
     * For more information about Amazon Redshift resource types and constructing ARNs, go to
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN) in the
     * Amazon Redshift Cluster Management Guide.
     */
    val resourceType: String? = builder.resourceType
    /**
     * The tag for the resource.
     */
    val tag: Tag? = builder.tag

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TaggedResource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TaggedResource(")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("tag=$tag)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceName?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tag?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TaggedResource

        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (tag != other.tag) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TaggedResource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TaggedResource
        /**
         * The Amazon Resource Name (ARN) with which the tag is associated, for example:
         * arn:aws:redshift:us-east-2:123456789:cluster:t1.
         */
        fun resourceName(resourceName: String): FluentBuilder
        /**
         * The type of resource with which the tag is associated. Valid resource types are:
         * Cluster
         * CIDR/IP
         * EC2 security group
         * Snapshot
         * Cluster security group
         * Subnet group
         * HSM connection
         * HSM certificate
         * Parameter group
         * For more information about Amazon Redshift resource types and constructing ARNs, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN) in the
         * Amazon Redshift Cluster Management Guide.
         */
        fun resourceType(resourceType: String): FluentBuilder
        /**
         * The tag for the resource.
         */
        fun tag(tag: Tag): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) with which the tag is associated, for example:
         * arn:aws:redshift:us-east-2:123456789:cluster:t1.
         */
        var resourceName: String?
        /**
         * The type of resource with which the tag is associated. Valid resource types are:
         * Cluster
         * CIDR/IP
         * EC2 security group
         * Snapshot
         * Cluster security group
         * Subnet group
         * HSM connection
         * HSM certificate
         * Parameter group
         * For more information about Amazon Redshift resource types and constructing ARNs, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN) in the
         * Amazon Redshift Cluster Management Guide.
         */
        var resourceType: String?
        /**
         * The tag for the resource.
         */
        var tag: Tag?

        fun build(): TaggedResource
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.Tag] inside the given [block]
         */
        fun tag(block: Tag.DslBuilder.() -> kotlin.Unit) {
            this.tag = Tag.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceName: String? = null
        override var resourceType: String? = null
        override var tag: Tag? = null

        constructor(x: TaggedResource) : this() {
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.tag = x.tag
        }

        override fun build(): TaggedResource = TaggedResource(this)
        override fun resourceName(resourceName: String): FluentBuilder = apply { this.resourceName = resourceName }
        override fun resourceType(resourceType: String): FluentBuilder = apply { this.resourceType = resourceType }
        override fun tag(tag: Tag): FluentBuilder = apply { this.tag = tag }
    }
}
