// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of a RestoreTableFromClusterSnapshot
 * operation.
 */
class TableRestoreStatus private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the Amazon Redshift cluster that the table is being restored
     * to.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A description of the status of the table restore request. Status values include
     * SUCCEEDED, FAILED, CANCELED,
     * PENDING, IN_PROGRESS.
     */
    val message: String? = builder.message
    /**
     * The name of the table to create as a result of the table restore request.
     */
    val newTableName: String? = builder.newTableName
    /**
     * The amount of data restored to the new table so far, in megabytes (MB).
     */
    val progressInMegaBytes: Long? = builder.progressInMegaBytes
    /**
     * The time that the table restore request was made, in Universal Coordinated Time
     * (UTC).
     */
    val requestTime: Instant? = builder.requestTime
    /**
     * The identifier of the snapshot that the table is being restored from.
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier
    /**
     * The name of the source database that contains the table being restored.
     */
    val sourceDatabaseName: String? = builder.sourceDatabaseName
    /**
     * The name of the source schema that contains the table being restored.
     */
    val sourceSchemaName: String? = builder.sourceSchemaName
    /**
     * The name of the source table being restored.
     */
    val sourceTableName: String? = builder.sourceTableName
    /**
     * A value that describes the current state of the table restore request.
     * Valid Values: SUCCEEDED, FAILED, CANCELED,
     * PENDING, IN_PROGRESS
     */
    val status: TableRestoreStatusType? = builder.status
    /**
     * The unique identifier for the table restore request.
     */
    val tableRestoreRequestId: String? = builder.tableRestoreRequestId
    /**
     * The name of the database to restore the table to.
     */
    val targetDatabaseName: String? = builder.targetDatabaseName
    /**
     * The name of the schema to restore the table to.
     */
    val targetSchemaName: String? = builder.targetSchemaName
    /**
     * The total amount of data to restore to the new table, in megabytes (MB).
     */
    val totalDataInMegaBytes: Long? = builder.totalDataInMegaBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TableRestoreStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TableRestoreStatus(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("message=$message,")
        append("newTableName=$newTableName,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("requestTime=$requestTime,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("sourceDatabaseName=$sourceDatabaseName,")
        append("sourceSchemaName=$sourceSchemaName,")
        append("sourceTableName=$sourceTableName,")
        append("status=$status,")
        append("tableRestoreRequestId=$tableRestoreRequestId,")
        append("targetDatabaseName=$targetDatabaseName,")
        append("targetSchemaName=$targetSchemaName,")
        append("totalDataInMegaBytes=$totalDataInMegaBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (newTableName?.hashCode() ?: 0)
        result = 31 * result + (progressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (requestTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (sourceSchemaName?.hashCode() ?: 0)
        result = 31 * result + (sourceTableName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tableRestoreRequestId?.hashCode() ?: 0)
        result = 31 * result + (targetDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (targetSchemaName?.hashCode() ?: 0)
        result = 31 * result + (totalDataInMegaBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TableRestoreStatus

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (message != other.message) return false
        if (newTableName != other.newTableName) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (requestTime != other.requestTime) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (sourceDatabaseName != other.sourceDatabaseName) return false
        if (sourceSchemaName != other.sourceSchemaName) return false
        if (sourceTableName != other.sourceTableName) return false
        if (status != other.status) return false
        if (tableRestoreRequestId != other.tableRestoreRequestId) return false
        if (targetDatabaseName != other.targetDatabaseName) return false
        if (targetSchemaName != other.targetSchemaName) return false
        if (totalDataInMegaBytes != other.totalDataInMegaBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TableRestoreStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TableRestoreStatus
        /**
         * The identifier of the Amazon Redshift cluster that the table is being restored
         * to.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A description of the status of the table restore request. Status values include
         * SUCCEEDED, FAILED, CANCELED,
         * PENDING, IN_PROGRESS.
         */
        fun message(message: String): FluentBuilder
        /**
         * The name of the table to create as a result of the table restore request.
         */
        fun newTableName(newTableName: String): FluentBuilder
        /**
         * The amount of data restored to the new table so far, in megabytes (MB).
         */
        fun progressInMegaBytes(progressInMegaBytes: Long): FluentBuilder
        /**
         * The time that the table restore request was made, in Universal Coordinated Time
         * (UTC).
         */
        fun requestTime(requestTime: Instant): FluentBuilder
        /**
         * The identifier of the snapshot that the table is being restored from.
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
        /**
         * The name of the source database that contains the table being restored.
         */
        fun sourceDatabaseName(sourceDatabaseName: String): FluentBuilder
        /**
         * The name of the source schema that contains the table being restored.
         */
        fun sourceSchemaName(sourceSchemaName: String): FluentBuilder
        /**
         * The name of the source table being restored.
         */
        fun sourceTableName(sourceTableName: String): FluentBuilder
        /**
         * A value that describes the current state of the table restore request.
         * Valid Values: SUCCEEDED, FAILED, CANCELED,
         * PENDING, IN_PROGRESS
         */
        fun status(status: TableRestoreStatusType): FluentBuilder
        /**
         * The unique identifier for the table restore request.
         */
        fun tableRestoreRequestId(tableRestoreRequestId: String): FluentBuilder
        /**
         * The name of the database to restore the table to.
         */
        fun targetDatabaseName(targetDatabaseName: String): FluentBuilder
        /**
         * The name of the schema to restore the table to.
         */
        fun targetSchemaName(targetSchemaName: String): FluentBuilder
        /**
         * The total amount of data to restore to the new table, in megabytes (MB).
         */
        fun totalDataInMegaBytes(totalDataInMegaBytes: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the Amazon Redshift cluster that the table is being restored
         * to.
         */
        var clusterIdentifier: String?
        /**
         * A description of the status of the table restore request. Status values include
         * SUCCEEDED, FAILED, CANCELED,
         * PENDING, IN_PROGRESS.
         */
        var message: String?
        /**
         * The name of the table to create as a result of the table restore request.
         */
        var newTableName: String?
        /**
         * The amount of data restored to the new table so far, in megabytes (MB).
         */
        var progressInMegaBytes: Long?
        /**
         * The time that the table restore request was made, in Universal Coordinated Time
         * (UTC).
         */
        var requestTime: Instant?
        /**
         * The identifier of the snapshot that the table is being restored from.
         */
        var snapshotIdentifier: String?
        /**
         * The name of the source database that contains the table being restored.
         */
        var sourceDatabaseName: String?
        /**
         * The name of the source schema that contains the table being restored.
         */
        var sourceSchemaName: String?
        /**
         * The name of the source table being restored.
         */
        var sourceTableName: String?
        /**
         * A value that describes the current state of the table restore request.
         * Valid Values: SUCCEEDED, FAILED, CANCELED,
         * PENDING, IN_PROGRESS
         */
        var status: TableRestoreStatusType?
        /**
         * The unique identifier for the table restore request.
         */
        var tableRestoreRequestId: String?
        /**
         * The name of the database to restore the table to.
         */
        var targetDatabaseName: String?
        /**
         * The name of the schema to restore the table to.
         */
        var targetSchemaName: String?
        /**
         * The total amount of data to restore to the new table, in megabytes (MB).
         */
        var totalDataInMegaBytes: Long?

        fun build(): TableRestoreStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var message: String? = null
        override var newTableName: String? = null
        override var progressInMegaBytes: Long? = null
        override var requestTime: Instant? = null
        override var snapshotIdentifier: String? = null
        override var sourceDatabaseName: String? = null
        override var sourceSchemaName: String? = null
        override var sourceTableName: String? = null
        override var status: TableRestoreStatusType? = null
        override var tableRestoreRequestId: String? = null
        override var targetDatabaseName: String? = null
        override var targetSchemaName: String? = null
        override var totalDataInMegaBytes: Long? = null

        constructor(x: TableRestoreStatus) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.message = x.message
            this.newTableName = x.newTableName
            this.progressInMegaBytes = x.progressInMegaBytes
            this.requestTime = x.requestTime
            this.snapshotIdentifier = x.snapshotIdentifier
            this.sourceDatabaseName = x.sourceDatabaseName
            this.sourceSchemaName = x.sourceSchemaName
            this.sourceTableName = x.sourceTableName
            this.status = x.status
            this.tableRestoreRequestId = x.tableRestoreRequestId
            this.targetDatabaseName = x.targetDatabaseName
            this.targetSchemaName = x.targetSchemaName
            this.totalDataInMegaBytes = x.totalDataInMegaBytes
        }

        override fun build(): TableRestoreStatus = TableRestoreStatus(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun newTableName(newTableName: String): FluentBuilder = apply { this.newTableName = newTableName }
        override fun progressInMegaBytes(progressInMegaBytes: Long): FluentBuilder = apply { this.progressInMegaBytes = progressInMegaBytes }
        override fun requestTime(requestTime: Instant): FluentBuilder = apply { this.requestTime = requestTime }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
        override fun sourceDatabaseName(sourceDatabaseName: String): FluentBuilder = apply { this.sourceDatabaseName = sourceDatabaseName }
        override fun sourceSchemaName(sourceSchemaName: String): FluentBuilder = apply { this.sourceSchemaName = sourceSchemaName }
        override fun sourceTableName(sourceTableName: String): FluentBuilder = apply { this.sourceTableName = sourceTableName }
        override fun status(status: TableRestoreStatusType): FluentBuilder = apply { this.status = status }
        override fun tableRestoreRequestId(tableRestoreRequestId: String): FluentBuilder = apply { this.tableRestoreRequestId = tableRestoreRequestId }
        override fun targetDatabaseName(targetDatabaseName: String): FluentBuilder = apply { this.targetDatabaseName = targetDatabaseName }
        override fun targetSchemaName(targetSchemaName: String): FluentBuilder = apply { this.targetSchemaName = targetSchemaName }
        override fun totalDataInMegaBytes(totalDataInMegaBytes: Long): FluentBuilder = apply { this.totalDataInMegaBytes = totalDataInMegaBytes }
    }
}
