// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * The snapshot copy grant that grants Amazon Redshift permission to encrypt copied
 * snapshots with the specified customer master key (CMK) from Amazon Web Services KMS in the destination
 * region.
 * For more information about managing snapshot copy grants, go to
 * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption
 * in the Amazon Redshift Cluster Management Guide.
 */
class SnapshotCopyGrant private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of the customer master key (CMK) in Amazon Web Services KMS to which
     * Amazon Redshift is granted permission.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the snapshot copy grant.
     */
    val snapshotCopyGrantName: String? = builder.snapshotCopyGrantName
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SnapshotCopyGrant = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotCopyGrant(")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SnapshotCopyGrant

        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SnapshotCopyGrant = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SnapshotCopyGrant
        /**
         * The unique identifier of the customer master key (CMK) in Amazon Web Services KMS to which
         * Amazon Redshift is granted permission.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the snapshot copy grant.
         */
        fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of the customer master key (CMK) in Amazon Web Services KMS to which
         * Amazon Redshift is granted permission.
         */
        var kmsKeyId: String?
        /**
         * The name of the snapshot copy grant.
         */
        var snapshotCopyGrantName: String?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?

        fun build(): SnapshotCopyGrant
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsKeyId: String? = null
        override var snapshotCopyGrantName: String? = null
        override var tags: List<Tag>? = null

        constructor(x: SnapshotCopyGrant) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
            this.tags = x.tags
        }

        override fun build(): SnapshotCopyGrant = SnapshotCopyGrant(this)
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder = apply { this.snapshotCopyGrantName = snapshotCopyGrantName }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
