// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot.
 */
class Snapshot private constructor(builder: BuilderImpl) {
    /**
     * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns
     * null if no accounts are authorized. Visible only to the snapshot owner.
     */
    val accountsWithRestoreAccess: List<AccountWithRestoreAccess>? = builder.accountsWithRestoreAccess
    /**
     * The size of the incremental backup.
     */
    val actualIncrementalBackupSizeInMegaBytes: Double = builder.actualIncrementalBackupSizeInMegaBytes
    /**
     * The Availability Zone in which the cluster was created.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The number of megabytes that have been transferred to the snapshot
     * backup.
     */
    val backupProgressInMegaBytes: Double = builder.backupProgressInMegaBytes
    /**
     * The time (UTC) when the cluster was originally created.
     */
    val clusterCreateTime: Instant? = builder.clusterCreateTime
    /**
     * The identifier of the cluster for which the snapshot was taken.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    val clusterVersion: String? = builder.clusterVersion
    /**
     * The number of megabytes per second being transferred to the snapshot backup.
     * Returns 0 for a completed backup.
     */
    val currentBackupRateInMegaBytesPerSecond: Double = builder.currentBackupRateInMegaBytesPerSecond
    /**
     * The name of the database that was created when the cluster was created.
     */
    val dbName: String? = builder.dbName
    /**
     * The amount of time an in-progress snapshot backup has been running, or the amount
     * of time it took a completed backup to finish.
     */
    val elapsedTimeInSeconds: Long = builder.elapsedTimeInSeconds
    /**
     * If true, the data in the snapshot is encrypted at rest.
     */
    val encrypted: Boolean = builder.encrypted
    /**
     * A boolean that indicates whether the snapshot data is encrypted using the HSM keys
     * of the source cluster. true indicates that the data is encrypted using HSM
     * keys.
     */
    val encryptedWithHsm: Boolean = builder.encryptedWithHsm
    /**
     * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
     */
    val engineFullVersion: String? = builder.engineFullVersion
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing
     * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
     * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
     * the Amazon Redshift Cluster Management Guide.
     * If this option is true, enhanced VPC routing is enabled.
     * Default: false
     */
    val enhancedVpcRouting: Boolean = builder.enhancedVpcRouting
    /**
     * The estimate of the time remaining before the snapshot backup will complete.
     * Returns 0 for a completed backup.
     */
    val estimatedSecondsToCompletion: Long = builder.estimatedSecondsToCompletion
    /**
     * The Key Management Service (KMS) key ID of the encryption key that was used to
     * encrypt data in the cluster from which the snapshot was taken.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the snapshot.
     */
    val maintenanceTrackName: String? = builder.maintenanceTrackName
    /**
     * The number of days until a manual snapshot will pass its retention period.
     */
    val manualSnapshotRemainingDays: Int? = builder.manualSnapshotRemainingDays
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual
     * snapshot is retained indefinitely.
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The admin user name for the cluster.
     */
    val masterUsername: String? = builder.masterUsername
    /**
     * The node type of the nodes in the cluster.
     */
    val nodeType: String? = builder.nodeType
    /**
     * The number of nodes in the cluster.
     */
    val numberOfNodes: Int = builder.numberOfNodes
    /**
     * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot.
     * For automatic snapshots, the owner of the cluster. The owner can perform all snapshot
     * actions, such as sharing a manual snapshot.
     */
    val ownerAccount: String? = builder.ownerAccount
    /**
     * The port that the cluster is listening on.
     */
    val port: Int = builder.port
    /**
     * The list of node types that this cluster snapshot is able to restore
     * into.
     */
    val restorableNodeTypes: List<String>? = builder.restorableNodeTypes
    /**
     * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a
     * copy of the cluster data as of this exact time.
     */
    val snapshotCreateTime: Instant? = builder.snapshotCreateTime
    /**
     * The snapshot identifier that is provided in the request.
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier
    /**
     * A timestamp representing the start of the retention period for the snapshot.
     */
    val snapshotRetentionStartTime: Instant? = builder.snapshotRetentionStartTime
    /**
     * The snapshot type. Snapshots created using CreateClusterSnapshot
     * and CopyClusterSnapshot are of type "manual".
     */
    val snapshotType: String? = builder.snapshotType
    /**
     * The source region from which the snapshot was copied.
     */
    val sourceRegion: String? = builder.sourceRegion
    /**
     * The snapshot status. The value of the status depends on the API operation used:
     * CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
     * DescribeClusterSnapshots returns status as "creating",
     * "available", "final snapshot", or "failed".
     * DeleteClusterSnapshot returns status as "deleted".
     */
    val status: String? = builder.status
    /**
     * The list of tags for the cluster snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The size of the complete set of backup data that would be used to restore the
     * cluster.
     */
    val totalBackupSizeInMegaBytes: Double = builder.totalBackupSizeInMegaBytes
    /**
     * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC.
     * Otherwise, this field is not in the output.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Snapshot = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("accountsWithRestoreAccess=$accountsWithRestoreAccess,")
        append("actualIncrementalBackupSizeInMegaBytes=$actualIncrementalBackupSizeInMegaBytes,")
        append("availabilityZone=$availabilityZone,")
        append("backupProgressInMegaBytes=$backupProgressInMegaBytes,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterVersion=$clusterVersion,")
        append("currentBackupRateInMegaBytesPerSecond=$currentBackupRateInMegaBytesPerSecond,")
        append("dbName=$dbName,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("encrypted=$encrypted,")
        append("encryptedWithHsm=$encryptedWithHsm,")
        append("engineFullVersion=$engineFullVersion,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("estimatedSecondsToCompletion=$estimatedSecondsToCompletion,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRemainingDays=$manualSnapshotRemainingDays,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUsername=$masterUsername,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("ownerAccount=$ownerAccount,")
        append("port=$port,")
        append("restorableNodeTypes=$restorableNodeTypes,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotRetentionStartTime=$snapshotRetentionStartTime,")
        append("snapshotType=$snapshotType,")
        append("sourceRegion=$sourceRegion,")
        append("status=$status,")
        append("tags=$tags,")
        append("totalBackupSizeInMegaBytes=$totalBackupSizeInMegaBytes,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountsWithRestoreAccess?.hashCode() ?: 0
        result = 31 * result + (actualIncrementalBackupSizeInMegaBytes.hashCode())
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupProgressInMegaBytes.hashCode())
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (currentBackupRateInMegaBytesPerSecond.hashCode())
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (elapsedTimeInSeconds.hashCode())
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (encryptedWithHsm.hashCode())
        result = 31 * result + (engineFullVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting.hashCode())
        result = 31 * result + (estimatedSecondsToCompletion.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRemainingDays ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (restorableNodeTypes?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionStartTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalBackupSizeInMegaBytes.hashCode())
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Snapshot

        if (accountsWithRestoreAccess != other.accountsWithRestoreAccess) return false
        if (actualIncrementalBackupSizeInMegaBytes != other.actualIncrementalBackupSizeInMegaBytes) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupProgressInMegaBytes != other.backupProgressInMegaBytes) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterVersion != other.clusterVersion) return false
        if (currentBackupRateInMegaBytesPerSecond != other.currentBackupRateInMegaBytesPerSecond) return false
        if (dbName != other.dbName) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (encrypted != other.encrypted) return false
        if (encryptedWithHsm != other.encryptedWithHsm) return false
        if (engineFullVersion != other.engineFullVersion) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (estimatedSecondsToCompletion != other.estimatedSecondsToCompletion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRemainingDays != other.manualSnapshotRemainingDays) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUsername != other.masterUsername) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (ownerAccount != other.ownerAccount) return false
        if (port != other.port) return false
        if (restorableNodeTypes != other.restorableNodeTypes) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotRetentionStartTime != other.snapshotRetentionStartTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceRegion != other.sourceRegion) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (totalBackupSizeInMegaBytes != other.totalBackupSizeInMegaBytes) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Snapshot = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Snapshot
        /**
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns
         * null if no accounts are authorized. Visible only to the snapshot owner.
         */
        fun accountsWithRestoreAccess(accountsWithRestoreAccess: List<AccountWithRestoreAccess>): FluentBuilder
        /**
         * The size of the incremental backup.
         */
        fun actualIncrementalBackupSizeInMegaBytes(actualIncrementalBackupSizeInMegaBytes: Double): FluentBuilder
        /**
         * The Availability Zone in which the cluster was created.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The number of megabytes that have been transferred to the snapshot
         * backup.
         */
        fun backupProgressInMegaBytes(backupProgressInMegaBytes: Double): FluentBuilder
        /**
         * The time (UTC) when the cluster was originally created.
         */
        fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder
        /**
         * The identifier of the cluster for which the snapshot was taken.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        fun clusterVersion(clusterVersion: String): FluentBuilder
        /**
         * The number of megabytes per second being transferred to the snapshot backup.
         * Returns 0 for a completed backup.
         */
        fun currentBackupRateInMegaBytesPerSecond(currentBackupRateInMegaBytesPerSecond: Double): FluentBuilder
        /**
         * The name of the database that was created when the cluster was created.
         */
        fun dbName(dbName: String): FluentBuilder
        /**
         * The amount of time an in-progress snapshot backup has been running, or the amount
         * of time it took a completed backup to finish.
         */
        fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder
        /**
         * If true, the data in the snapshot is encrypted at rest.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * A boolean that indicates whether the snapshot data is encrypted using the HSM keys
         * of the source cluster. true indicates that the data is encrypted using HSM
         * keys.
         */
        fun encryptedWithHsm(encryptedWithHsm: Boolean): FluentBuilder
        /**
         * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
         */
        fun engineFullVersion(engineFullVersion: String): FluentBuilder
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder
        /**
         * The estimate of the time remaining before the snapshot backup will complete.
         * Returns 0 for a completed backup.
         */
        fun estimatedSecondsToCompletion(estimatedSecondsToCompletion: Long): FluentBuilder
        /**
         * The Key Management Service (KMS) key ID of the encryption key that was used to
         * encrypt data in the cluster from which the snapshot was taken.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the maintenance track for the snapshot.
         */
        fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder
        /**
         * The number of days until a manual snapshot will pass its retention period.
         */
        fun manualSnapshotRemainingDays(manualSnapshotRemainingDays: Int): FluentBuilder
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The admin user name for the cluster.
         */
        fun masterUsername(masterUsername: String): FluentBuilder
        /**
         * The node type of the nodes in the cluster.
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The number of nodes in the cluster.
         */
        fun numberOfNodes(numberOfNodes: Int): FluentBuilder
        /**
         * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot.
         * For automatic snapshots, the owner of the cluster. The owner can perform all snapshot
         * actions, such as sharing a manual snapshot.
         */
        fun ownerAccount(ownerAccount: String): FluentBuilder
        /**
         * The port that the cluster is listening on.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The list of node types that this cluster snapshot is able to restore
         * into.
         */
        fun restorableNodeTypes(restorableNodeTypes: List<String>): FluentBuilder
        /**
         * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a
         * copy of the cluster data as of this exact time.
         */
        fun snapshotCreateTime(snapshotCreateTime: Instant): FluentBuilder
        /**
         * The snapshot identifier that is provided in the request.
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
        /**
         * A timestamp representing the start of the retention period for the snapshot.
         */
        fun snapshotRetentionStartTime(snapshotRetentionStartTime: Instant): FluentBuilder
        /**
         * The snapshot type. Snapshots created using CreateClusterSnapshot
         * and CopyClusterSnapshot are of type "manual".
         */
        fun snapshotType(snapshotType: String): FluentBuilder
        /**
         * The source region from which the snapshot was copied.
         */
        fun sourceRegion(sourceRegion: String): FluentBuilder
        /**
         * The snapshot status. The value of the status depends on the API operation used:
         * CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
         * DescribeClusterSnapshots returns status as "creating",
         * "available", "final snapshot", or "failed".
         * DeleteClusterSnapshot returns status as "deleted".
         */
        fun status(status: String): FluentBuilder
        /**
         * The list of tags for the cluster snapshot.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The size of the complete set of backup data that would be used to restore the
         * cluster.
         */
        fun totalBackupSizeInMegaBytes(totalBackupSizeInMegaBytes: Double): FluentBuilder
        /**
         * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC.
         * Otherwise, this field is not in the output.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns
         * null if no accounts are authorized. Visible only to the snapshot owner.
         */
        var accountsWithRestoreAccess: List<AccountWithRestoreAccess>?
        /**
         * The size of the incremental backup.
         */
        var actualIncrementalBackupSizeInMegaBytes: Double
        /**
         * The Availability Zone in which the cluster was created.
         */
        var availabilityZone: String?
        /**
         * The number of megabytes that have been transferred to the snapshot
         * backup.
         */
        var backupProgressInMegaBytes: Double
        /**
         * The time (UTC) when the cluster was originally created.
         */
        var clusterCreateTime: Instant?
        /**
         * The identifier of the cluster for which the snapshot was taken.
         */
        var clusterIdentifier: String?
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        var clusterVersion: String?
        /**
         * The number of megabytes per second being transferred to the snapshot backup.
         * Returns 0 for a completed backup.
         */
        var currentBackupRateInMegaBytesPerSecond: Double
        /**
         * The name of the database that was created when the cluster was created.
         */
        var dbName: String?
        /**
         * The amount of time an in-progress snapshot backup has been running, or the amount
         * of time it took a completed backup to finish.
         */
        var elapsedTimeInSeconds: Long
        /**
         * If true, the data in the snapshot is encrypted at rest.
         */
        var encrypted: Boolean
        /**
         * A boolean that indicates whether the snapshot data is encrypted using the HSM keys
         * of the source cluster. true indicates that the data is encrypted using HSM
         * keys.
         */
        var encryptedWithHsm: Boolean
        /**
         * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
         */
        var engineFullVersion: String?
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        var enhancedVpcRouting: Boolean
        /**
         * The estimate of the time remaining before the snapshot backup will complete.
         * Returns 0 for a completed backup.
         */
        var estimatedSecondsToCompletion: Long
        /**
         * The Key Management Service (KMS) key ID of the encryption key that was used to
         * encrypt data in the cluster from which the snapshot was taken.
         */
        var kmsKeyId: String?
        /**
         * The name of the maintenance track for the snapshot.
         */
        var maintenanceTrackName: String?
        /**
         * The number of days until a manual snapshot will pass its retention period.
         */
        var manualSnapshotRemainingDays: Int?
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: Int?
        /**
         * The admin user name for the cluster.
         */
        var masterUsername: String?
        /**
         * The node type of the nodes in the cluster.
         */
        var nodeType: String?
        /**
         * The number of nodes in the cluster.
         */
        var numberOfNodes: Int
        /**
         * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot.
         * For automatic snapshots, the owner of the cluster. The owner can perform all snapshot
         * actions, such as sharing a manual snapshot.
         */
        var ownerAccount: String?
        /**
         * The port that the cluster is listening on.
         */
        var port: Int
        /**
         * The list of node types that this cluster snapshot is able to restore
         * into.
         */
        var restorableNodeTypes: List<String>?
        /**
         * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a
         * copy of the cluster data as of this exact time.
         */
        var snapshotCreateTime: Instant?
        /**
         * The snapshot identifier that is provided in the request.
         */
        var snapshotIdentifier: String?
        /**
         * A timestamp representing the start of the retention period for the snapshot.
         */
        var snapshotRetentionStartTime: Instant?
        /**
         * The snapshot type. Snapshots created using CreateClusterSnapshot
         * and CopyClusterSnapshot are of type "manual".
         */
        var snapshotType: String?
        /**
         * The source region from which the snapshot was copied.
         */
        var sourceRegion: String?
        /**
         * The snapshot status. The value of the status depends on the API operation used:
         * CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
         * DescribeClusterSnapshots returns status as "creating",
         * "available", "final snapshot", or "failed".
         * DeleteClusterSnapshot returns status as "deleted".
         */
        var status: String?
        /**
         * The list of tags for the cluster snapshot.
         */
        var tags: List<Tag>?
        /**
         * The size of the complete set of backup data that would be used to restore the
         * cluster.
         */
        var totalBackupSizeInMegaBytes: Double
        /**
         * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC.
         * Otherwise, this field is not in the output.
         */
        var vpcId: String?

        fun build(): Snapshot
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountsWithRestoreAccess: List<AccountWithRestoreAccess>? = null
        override var actualIncrementalBackupSizeInMegaBytes: Double = 0.0
        override var availabilityZone: String? = null
        override var backupProgressInMegaBytes: Double = 0.0
        override var clusterCreateTime: Instant? = null
        override var clusterIdentifier: String? = null
        override var clusterVersion: String? = null
        override var currentBackupRateInMegaBytesPerSecond: Double = 0.0
        override var dbName: String? = null
        override var elapsedTimeInSeconds: Long = 0L
        override var encrypted: Boolean = false
        override var encryptedWithHsm: Boolean = false
        override var engineFullVersion: String? = null
        override var enhancedVpcRouting: Boolean = false
        override var estimatedSecondsToCompletion: Long = 0L
        override var kmsKeyId: String? = null
        override var maintenanceTrackName: String? = null
        override var manualSnapshotRemainingDays: Int? = null
        override var manualSnapshotRetentionPeriod: Int? = null
        override var masterUsername: String? = null
        override var nodeType: String? = null
        override var numberOfNodes: Int = 0
        override var ownerAccount: String? = null
        override var port: Int = 0
        override var restorableNodeTypes: List<String>? = null
        override var snapshotCreateTime: Instant? = null
        override var snapshotIdentifier: String? = null
        override var snapshotRetentionStartTime: Instant? = null
        override var snapshotType: String? = null
        override var sourceRegion: String? = null
        override var status: String? = null
        override var tags: List<Tag>? = null
        override var totalBackupSizeInMegaBytes: Double = 0.0
        override var vpcId: String? = null

        constructor(x: Snapshot) : this() {
            this.accountsWithRestoreAccess = x.accountsWithRestoreAccess
            this.actualIncrementalBackupSizeInMegaBytes = x.actualIncrementalBackupSizeInMegaBytes
            this.availabilityZone = x.availabilityZone
            this.backupProgressInMegaBytes = x.backupProgressInMegaBytes
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterVersion = x.clusterVersion
            this.currentBackupRateInMegaBytesPerSecond = x.currentBackupRateInMegaBytesPerSecond
            this.dbName = x.dbName
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.encrypted = x.encrypted
            this.encryptedWithHsm = x.encryptedWithHsm
            this.engineFullVersion = x.engineFullVersion
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.estimatedSecondsToCompletion = x.estimatedSecondsToCompletion
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRemainingDays = x.manualSnapshotRemainingDays
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUsername = x.masterUsername
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.ownerAccount = x.ownerAccount
            this.port = x.port
            this.restorableNodeTypes = x.restorableNodeTypes
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotRetentionStartTime = x.snapshotRetentionStartTime
            this.snapshotType = x.snapshotType
            this.sourceRegion = x.sourceRegion
            this.status = x.status
            this.tags = x.tags
            this.totalBackupSizeInMegaBytes = x.totalBackupSizeInMegaBytes
            this.vpcId = x.vpcId
        }

        override fun build(): Snapshot = Snapshot(this)
        override fun accountsWithRestoreAccess(accountsWithRestoreAccess: List<AccountWithRestoreAccess>): FluentBuilder = apply { this.accountsWithRestoreAccess = accountsWithRestoreAccess }
        override fun actualIncrementalBackupSizeInMegaBytes(actualIncrementalBackupSizeInMegaBytes: Double): FluentBuilder = apply { this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun backupProgressInMegaBytes(backupProgressInMegaBytes: Double): FluentBuilder = apply { this.backupProgressInMegaBytes = backupProgressInMegaBytes }
        override fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder = apply { this.clusterCreateTime = clusterCreateTime }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun clusterVersion(clusterVersion: String): FluentBuilder = apply { this.clusterVersion = clusterVersion }
        override fun currentBackupRateInMegaBytesPerSecond(currentBackupRateInMegaBytesPerSecond: Double): FluentBuilder = apply { this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond }
        override fun dbName(dbName: String): FluentBuilder = apply { this.dbName = dbName }
        override fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder = apply { this.elapsedTimeInSeconds = elapsedTimeInSeconds }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun encryptedWithHsm(encryptedWithHsm: Boolean): FluentBuilder = apply { this.encryptedWithHsm = encryptedWithHsm }
        override fun engineFullVersion(engineFullVersion: String): FluentBuilder = apply { this.engineFullVersion = engineFullVersion }
        override fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder = apply { this.enhancedVpcRouting = enhancedVpcRouting }
        override fun estimatedSecondsToCompletion(estimatedSecondsToCompletion: Long): FluentBuilder = apply { this.estimatedSecondsToCompletion = estimatedSecondsToCompletion }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder = apply { this.maintenanceTrackName = maintenanceTrackName }
        override fun manualSnapshotRemainingDays(manualSnapshotRemainingDays: Int): FluentBuilder = apply { this.manualSnapshotRemainingDays = manualSnapshotRemainingDays }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun masterUsername(masterUsername: String): FluentBuilder = apply { this.masterUsername = masterUsername }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun numberOfNodes(numberOfNodes: Int): FluentBuilder = apply { this.numberOfNodes = numberOfNodes }
        override fun ownerAccount(ownerAccount: String): FluentBuilder = apply { this.ownerAccount = ownerAccount }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun restorableNodeTypes(restorableNodeTypes: List<String>): FluentBuilder = apply { this.restorableNodeTypes = restorableNodeTypes }
        override fun snapshotCreateTime(snapshotCreateTime: Instant): FluentBuilder = apply { this.snapshotCreateTime = snapshotCreateTime }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
        override fun snapshotRetentionStartTime(snapshotRetentionStartTime: Instant): FluentBuilder = apply { this.snapshotRetentionStartTime = snapshotRetentionStartTime }
        override fun snapshotType(snapshotType: String): FluentBuilder = apply { this.snapshotType = snapshotType }
        override fun sourceRegion(sourceRegion: String): FluentBuilder = apply { this.sourceRegion = sourceRegion }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun totalBackupSizeInMegaBytes(totalBackupSizeInMegaBytes: Double): FluentBuilder = apply { this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
