// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.
 */
class RevokeEndpointAccessResponse private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
     */
    val allowedAllVpCs: Boolean = builder.allowedAllVpCs
    /**
     * The VPCs allowed access to the cluster.
     */
    val allowedVpCs: List<String>? = builder.allowedVpCs
    /**
     * The time (UTC) when the authorization was created.
     */
    val authorizeTime: Instant? = builder.authorizeTime
    /**
     * The cluster identifier.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The status of the cluster.
     */
    val clusterStatus: String? = builder.clusterStatus
    /**
     * The number of Redshift-managed VPC endpoints created for the authorization.
     */
    val endpointCount: Int = builder.endpointCount
    /**
     * The Amazon Web Services account ID of the grantee of the cluster.
     */
    val grantee: String? = builder.grantee
    /**
     * The Amazon Web Services account ID of the cluster owner.
     */
    val grantor: String? = builder.grantor
    /**
     * The status of the authorization action.
     */
    val status: AuthorizationStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RevokeEndpointAccessResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeEndpointAccessResponse(")
        append("allowedAllVpCs=$allowedAllVpCs,")
        append("allowedVpCs=$allowedVpCs,")
        append("authorizeTime=$authorizeTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterStatus=$clusterStatus,")
        append("endpointCount=$endpointCount,")
        append("grantee=$grantee,")
        append("grantor=$grantor,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAllVpCs.hashCode()
        result = 31 * result + (allowedVpCs?.hashCode() ?: 0)
        result = 31 * result + (authorizeTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterStatus?.hashCode() ?: 0)
        result = 31 * result + (endpointCount)
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (grantor?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RevokeEndpointAccessResponse

        if (allowedAllVpCs != other.allowedAllVpCs) return false
        if (allowedVpCs != other.allowedVpCs) return false
        if (authorizeTime != other.authorizeTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterStatus != other.clusterStatus) return false
        if (endpointCount != other.endpointCount) return false
        if (grantee != other.grantee) return false
        if (grantor != other.grantor) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RevokeEndpointAccessResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RevokeEndpointAccessResponse
        /**
         * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
         */
        fun allowedAllVpCs(allowedAllVpCs: Boolean): FluentBuilder
        /**
         * The VPCs allowed access to the cluster.
         */
        fun allowedVpCs(allowedVpCs: List<String>): FluentBuilder
        /**
         * The time (UTC) when the authorization was created.
         */
        fun authorizeTime(authorizeTime: Instant): FluentBuilder
        /**
         * The cluster identifier.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The status of the cluster.
         */
        fun clusterStatus(clusterStatus: String): FluentBuilder
        /**
         * The number of Redshift-managed VPC endpoints created for the authorization.
         */
        fun endpointCount(endpointCount: Int): FluentBuilder
        /**
         * The Amazon Web Services account ID of the grantee of the cluster.
         */
        fun grantee(grantee: String): FluentBuilder
        /**
         * The Amazon Web Services account ID of the cluster owner.
         */
        fun grantor(grantor: String): FluentBuilder
        /**
         * The status of the authorization action.
         */
        fun status(status: AuthorizationStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
         */
        var allowedAllVpCs: Boolean
        /**
         * The VPCs allowed access to the cluster.
         */
        var allowedVpCs: List<String>?
        /**
         * The time (UTC) when the authorization was created.
         */
        var authorizeTime: Instant?
        /**
         * The cluster identifier.
         */
        var clusterIdentifier: String?
        /**
         * The status of the cluster.
         */
        var clusterStatus: String?
        /**
         * The number of Redshift-managed VPC endpoints created for the authorization.
         */
        var endpointCount: Int
        /**
         * The Amazon Web Services account ID of the grantee of the cluster.
         */
        var grantee: String?
        /**
         * The Amazon Web Services account ID of the cluster owner.
         */
        var grantor: String?
        /**
         * The status of the authorization action.
         */
        var status: AuthorizationStatus?

        fun build(): RevokeEndpointAccessResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowedAllVpCs: Boolean = false
        override var allowedVpCs: List<String>? = null
        override var authorizeTime: Instant? = null
        override var clusterIdentifier: String? = null
        override var clusterStatus: String? = null
        override var endpointCount: Int = 0
        override var grantee: String? = null
        override var grantor: String? = null
        override var status: AuthorizationStatus? = null

        constructor(x: RevokeEndpointAccessResponse) : this() {
            this.allowedAllVpCs = x.allowedAllVpCs
            this.allowedVpCs = x.allowedVpCs
            this.authorizeTime = x.authorizeTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterStatus = x.clusterStatus
            this.endpointCount = x.endpointCount
            this.grantee = x.grantee
            this.grantor = x.grantor
            this.status = x.status
        }

        override fun build(): RevokeEndpointAccessResponse = RevokeEndpointAccessResponse(this)
        override fun allowedAllVpCs(allowedAllVpCs: Boolean): FluentBuilder = apply { this.allowedAllVpCs = allowedAllVpCs }
        override fun allowedVpCs(allowedVpCs: List<String>): FluentBuilder = apply { this.allowedVpCs = allowedVpCs }
        override fun authorizeTime(authorizeTime: Instant): FluentBuilder = apply { this.authorizeTime = authorizeTime }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun clusterStatus(clusterStatus: String): FluentBuilder = apply { this.clusterStatus = clusterStatus }
        override fun endpointCount(endpointCount: Int): FluentBuilder = apply { this.endpointCount = endpointCount }
        override fun grantee(grantee: String): FluentBuilder = apply { this.grantee = grantee }
        override fun grantor(grantor: String): FluentBuilder = apply { this.grantor = grantor }
        override fun status(status: AuthorizationStatus): FluentBuilder = apply { this.status = status }
    }
}
