// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class RevokeEndpointAccessRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services account ID whose access is to be revoked.
     */
    val account: String? = builder.account
    /**
     * The cluster to revoke access from.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * Indicates whether to force the revoke action.
     * If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.
     */
    val force: Boolean = builder.force
    /**
     * The virtual private cloud (VPC) identifiers for which access is to be revoked.
     */
    val vpcIds: List<String>? = builder.vpcIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RevokeEndpointAccessRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeEndpointAccessRequest(")
        append("account=$account,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("force=$force,")
        append("vpcIds=$vpcIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (force.hashCode())
        result = 31 * result + (vpcIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RevokeEndpointAccessRequest

        if (account != other.account) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (force != other.force) return false
        if (vpcIds != other.vpcIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RevokeEndpointAccessRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RevokeEndpointAccessRequest
        /**
         * The Amazon Web Services account ID whose access is to be revoked.
         */
        fun account(account: String): FluentBuilder
        /**
         * The cluster to revoke access from.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * Indicates whether to force the revoke action.
         * If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.
         */
        fun force(force: Boolean): FluentBuilder
        /**
         * The virtual private cloud (VPC) identifiers for which access is to be revoked.
         */
        fun vpcIds(vpcIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services account ID whose access is to be revoked.
         */
        var account: String?
        /**
         * The cluster to revoke access from.
         */
        var clusterIdentifier: String?
        /**
         * Indicates whether to force the revoke action.
         * If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.
         */
        var force: Boolean
        /**
         * The virtual private cloud (VPC) identifiers for which access is to be revoked.
         */
        var vpcIds: List<String>?

        fun build(): RevokeEndpointAccessRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var account: String? = null
        override var clusterIdentifier: String? = null
        override var force: Boolean = false
        override var vpcIds: List<String>? = null

        constructor(x: RevokeEndpointAccessRequest) : this() {
            this.account = x.account
            this.clusterIdentifier = x.clusterIdentifier
            this.force = x.force
            this.vpcIds = x.vpcIds
        }

        override fun build(): RevokeEndpointAccessRequest = RevokeEndpointAccessRequest(this)
        override fun account(account: String): FluentBuilder = apply { this.account = account }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun force(force: Boolean): FluentBuilder = apply { this.force = force }
        override fun vpcIds(vpcIds: List<String>): FluentBuilder = apply { this.vpcIds = vpcIds }
    }
}
