// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class RestoreTableFromClusterSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the Amazon Redshift cluster to restore the table to.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * Indicates whether name identifiers for database, schema, and table are case sensitive.
     * If true, the names are case sensitive.
     * If false (default), the names are not case sensitive.
     */
    val enableCaseSensitiveIdentifier: Boolean? = builder.enableCaseSensitiveIdentifier
    /**
     * The name of the table to create as a result of the current request.
     */
    val newTableName: String? = builder.newTableName
    /**
     * The identifier of the snapshot to restore the table from. This snapshot must have
     * been created from the Amazon Redshift cluster specified by the
     * ClusterIdentifier parameter.
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier
    /**
     * The name of the source database that contains the table to restore from.
     */
    val sourceDatabaseName: String? = builder.sourceDatabaseName
    /**
     * The name of the source schema that contains the table to restore from. If you do
     * not specify a SourceSchemaName value, the default is
     * public.
     */
    val sourceSchemaName: String? = builder.sourceSchemaName
    /**
     * The name of the source table to restore from.
     */
    val sourceTableName: String? = builder.sourceTableName
    /**
     * The name of the database to restore the table to.
     */
    val targetDatabaseName: String? = builder.targetDatabaseName
    /**
     * The name of the schema to restore the table to.
     */
    val targetSchemaName: String? = builder.targetSchemaName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RestoreTableFromClusterSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTableFromClusterSnapshotRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("enableCaseSensitiveIdentifier=$enableCaseSensitiveIdentifier,")
        append("newTableName=$newTableName,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("sourceDatabaseName=$sourceDatabaseName,")
        append("sourceSchemaName=$sourceSchemaName,")
        append("sourceTableName=$sourceTableName,")
        append("targetDatabaseName=$targetDatabaseName,")
        append("targetSchemaName=$targetSchemaName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (enableCaseSensitiveIdentifier?.hashCode() ?: 0)
        result = 31 * result + (newTableName?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (sourceSchemaName?.hashCode() ?: 0)
        result = 31 * result + (sourceTableName?.hashCode() ?: 0)
        result = 31 * result + (targetDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (targetSchemaName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RestoreTableFromClusterSnapshotRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (enableCaseSensitiveIdentifier != other.enableCaseSensitiveIdentifier) return false
        if (newTableName != other.newTableName) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (sourceDatabaseName != other.sourceDatabaseName) return false
        if (sourceSchemaName != other.sourceSchemaName) return false
        if (sourceTableName != other.sourceTableName) return false
        if (targetDatabaseName != other.targetDatabaseName) return false
        if (targetSchemaName != other.targetSchemaName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RestoreTableFromClusterSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RestoreTableFromClusterSnapshotRequest
        /**
         * The identifier of the Amazon Redshift cluster to restore the table to.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * Indicates whether name identifiers for database, schema, and table are case sensitive.
         * If true, the names are case sensitive.
         * If false (default), the names are not case sensitive.
         */
        fun enableCaseSensitiveIdentifier(enableCaseSensitiveIdentifier: Boolean): FluentBuilder
        /**
         * The name of the table to create as a result of the current request.
         */
        fun newTableName(newTableName: String): FluentBuilder
        /**
         * The identifier of the snapshot to restore the table from. This snapshot must have
         * been created from the Amazon Redshift cluster specified by the
         * ClusterIdentifier parameter.
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
        /**
         * The name of the source database that contains the table to restore from.
         */
        fun sourceDatabaseName(sourceDatabaseName: String): FluentBuilder
        /**
         * The name of the source schema that contains the table to restore from. If you do
         * not specify a SourceSchemaName value, the default is
         * public.
         */
        fun sourceSchemaName(sourceSchemaName: String): FluentBuilder
        /**
         * The name of the source table to restore from.
         */
        fun sourceTableName(sourceTableName: String): FluentBuilder
        /**
         * The name of the database to restore the table to.
         */
        fun targetDatabaseName(targetDatabaseName: String): FluentBuilder
        /**
         * The name of the schema to restore the table to.
         */
        fun targetSchemaName(targetSchemaName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the Amazon Redshift cluster to restore the table to.
         */
        var clusterIdentifier: String?
        /**
         * Indicates whether name identifiers for database, schema, and table are case sensitive.
         * If true, the names are case sensitive.
         * If false (default), the names are not case sensitive.
         */
        var enableCaseSensitiveIdentifier: Boolean?
        /**
         * The name of the table to create as a result of the current request.
         */
        var newTableName: String?
        /**
         * The identifier of the snapshot to restore the table from. This snapshot must have
         * been created from the Amazon Redshift cluster specified by the
         * ClusterIdentifier parameter.
         */
        var snapshotIdentifier: String?
        /**
         * The name of the source database that contains the table to restore from.
         */
        var sourceDatabaseName: String?
        /**
         * The name of the source schema that contains the table to restore from. If you do
         * not specify a SourceSchemaName value, the default is
         * public.
         */
        var sourceSchemaName: String?
        /**
         * The name of the source table to restore from.
         */
        var sourceTableName: String?
        /**
         * The name of the database to restore the table to.
         */
        var targetDatabaseName: String?
        /**
         * The name of the schema to restore the table to.
         */
        var targetSchemaName: String?

        fun build(): RestoreTableFromClusterSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var enableCaseSensitiveIdentifier: Boolean? = null
        override var newTableName: String? = null
        override var snapshotIdentifier: String? = null
        override var sourceDatabaseName: String? = null
        override var sourceSchemaName: String? = null
        override var sourceTableName: String? = null
        override var targetDatabaseName: String? = null
        override var targetSchemaName: String? = null

        constructor(x: RestoreTableFromClusterSnapshotRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.enableCaseSensitiveIdentifier = x.enableCaseSensitiveIdentifier
            this.newTableName = x.newTableName
            this.snapshotIdentifier = x.snapshotIdentifier
            this.sourceDatabaseName = x.sourceDatabaseName
            this.sourceSchemaName = x.sourceSchemaName
            this.sourceTableName = x.sourceTableName
            this.targetDatabaseName = x.targetDatabaseName
            this.targetSchemaName = x.targetSchemaName
        }

        override fun build(): RestoreTableFromClusterSnapshotRequest = RestoreTableFromClusterSnapshotRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun enableCaseSensitiveIdentifier(enableCaseSensitiveIdentifier: Boolean): FluentBuilder = apply { this.enableCaseSensitiveIdentifier = enableCaseSensitiveIdentifier }
        override fun newTableName(newTableName: String): FluentBuilder = apply { this.newTableName = newTableName }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
        override fun sourceDatabaseName(sourceDatabaseName: String): FluentBuilder = apply { this.sourceDatabaseName = sourceDatabaseName }
        override fun sourceSchemaName(sourceSchemaName: String): FluentBuilder = apply { this.sourceSchemaName = sourceSchemaName }
        override fun sourceTableName(sourceTableName: String): FluentBuilder = apply { this.sourceTableName = sourceTableName }
        override fun targetDatabaseName(targetDatabaseName: String): FluentBuilder = apply { this.targetDatabaseName = targetDatabaseName }
        override fun targetSchemaName(targetSchemaName: String): FluentBuilder = apply { this.targetSchemaName = targetSchemaName }
    }
}
