// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of a cluster restore action. Returns null if the cluster was
 * not created by restoring a snapshot.
 */
class RestoreStatus private constructor(builder: BuilderImpl) {
    /**
     * The number of megabytes per second being transferred from the backup storage.
     * Returns the average rate for a completed backup.
     * This field is only updated when you restore to DC2 and DS2 node types.
     */
    val currentRestoreRateInMegaBytesPerSecond: Double = builder.currentRestoreRateInMegaBytesPerSecond
    /**
     * The amount of time an in-progress restore has been running, or the amount of time
     * it took a completed restore to finish.
     * This field is only updated when you restore to DC2 and DS2 node types.
     */
    val elapsedTimeInSeconds: Long = builder.elapsedTimeInSeconds
    /**
     * The estimate of the time remaining before the restore will complete. Returns 0 for
     * a completed restore.
     * This field is only updated when you restore to DC2 and DS2 node types.
     */
    val estimatedTimeToCompletionInSeconds: Long = builder.estimatedTimeToCompletionInSeconds
    /**
     * The number of megabytes that have been transferred from snapshot storage.
     * This field is only updated when you restore to DC2 and DS2 node types.
     */
    val progressInMegaBytes: Long = builder.progressInMegaBytes
    /**
     * The size of the set of snapshot data used to restore the cluster.
     * This field is only updated when you restore to DC2 and DS2 node types.
     */
    val snapshotSizeInMegaBytes: Long = builder.snapshotSizeInMegaBytes
    /**
     * The status of the restore action. Returns starting, restoring, completed, or
     * failed.
     */
    val status: String? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RestoreStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreStatus(")
        append("currentRestoreRateInMegaBytesPerSecond=$currentRestoreRateInMegaBytesPerSecond,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedTimeToCompletionInSeconds=$estimatedTimeToCompletionInSeconds,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("snapshotSizeInMegaBytes=$snapshotSizeInMegaBytes,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentRestoreRateInMegaBytesPerSecond.hashCode()
        result = 31 * result + (elapsedTimeInSeconds.hashCode())
        result = 31 * result + (estimatedTimeToCompletionInSeconds.hashCode())
        result = 31 * result + (progressInMegaBytes.hashCode())
        result = 31 * result + (snapshotSizeInMegaBytes.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RestoreStatus

        if (currentRestoreRateInMegaBytesPerSecond != other.currentRestoreRateInMegaBytesPerSecond) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedTimeToCompletionInSeconds != other.estimatedTimeToCompletionInSeconds) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (snapshotSizeInMegaBytes != other.snapshotSizeInMegaBytes) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RestoreStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RestoreStatus
        /**
         * The number of megabytes per second being transferred from the backup storage.
         * Returns the average rate for a completed backup.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        fun currentRestoreRateInMegaBytesPerSecond(currentRestoreRateInMegaBytesPerSecond: Double): FluentBuilder
        /**
         * The amount of time an in-progress restore has been running, or the amount of time
         * it took a completed restore to finish.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder
        /**
         * The estimate of the time remaining before the restore will complete. Returns 0 for
         * a completed restore.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        fun estimatedTimeToCompletionInSeconds(estimatedTimeToCompletionInSeconds: Long): FluentBuilder
        /**
         * The number of megabytes that have been transferred from snapshot storage.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        fun progressInMegaBytes(progressInMegaBytes: Long): FluentBuilder
        /**
         * The size of the set of snapshot data used to restore the cluster.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        fun snapshotSizeInMegaBytes(snapshotSizeInMegaBytes: Long): FluentBuilder
        /**
         * The status of the restore action. Returns starting, restoring, completed, or
         * failed.
         */
        fun status(status: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of megabytes per second being transferred from the backup storage.
         * Returns the average rate for a completed backup.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        var currentRestoreRateInMegaBytesPerSecond: Double
        /**
         * The amount of time an in-progress restore has been running, or the amount of time
         * it took a completed restore to finish.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        var elapsedTimeInSeconds: Long
        /**
         * The estimate of the time remaining before the restore will complete. Returns 0 for
         * a completed restore.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        var estimatedTimeToCompletionInSeconds: Long
        /**
         * The number of megabytes that have been transferred from snapshot storage.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        var progressInMegaBytes: Long
        /**
         * The size of the set of snapshot data used to restore the cluster.
         * This field is only updated when you restore to DC2 and DS2 node types.
         */
        var snapshotSizeInMegaBytes: Long
        /**
         * The status of the restore action. Returns starting, restoring, completed, or
         * failed.
         */
        var status: String?

        fun build(): RestoreStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currentRestoreRateInMegaBytesPerSecond: Double = 0.0
        override var elapsedTimeInSeconds: Long = 0L
        override var estimatedTimeToCompletionInSeconds: Long = 0L
        override var progressInMegaBytes: Long = 0L
        override var snapshotSizeInMegaBytes: Long = 0L
        override var status: String? = null

        constructor(x: RestoreStatus) : this() {
            this.currentRestoreRateInMegaBytesPerSecond = x.currentRestoreRateInMegaBytesPerSecond
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedTimeToCompletionInSeconds = x.estimatedTimeToCompletionInSeconds
            this.progressInMegaBytes = x.progressInMegaBytes
            this.snapshotSizeInMegaBytes = x.snapshotSizeInMegaBytes
            this.status = x.status
        }

        override fun build(): RestoreStatus = RestoreStatus(this)
        override fun currentRestoreRateInMegaBytesPerSecond(currentRestoreRateInMegaBytesPerSecond: Double): FluentBuilder = apply { this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond }
        override fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder = apply { this.elapsedTimeInSeconds = elapsedTimeInSeconds }
        override fun estimatedTimeToCompletionInSeconds(estimatedTimeToCompletionInSeconds: Long): FluentBuilder = apply { this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds }
        override fun progressInMegaBytes(progressInMegaBytes: Long): FluentBuilder = apply { this.progressInMegaBytes = progressInMegaBytes }
        override fun snapshotSizeInMegaBytes(snapshotSizeInMegaBytes: Long): FluentBuilder = apply { this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
    }
}
